<?php  




/**
 * Data extraction
 * @var $schedulefilter = text flag of the parameter taxonomy
 * @var $today = return only current day
 */

extract( shortcode_atts( array(
	'schedulefilter' => '',
	'schedule_template' => false,
	'schedule_switch' => false,
	'schedule_style' => '',
	'thumbsize' => 'medium'
), $args ) );



$return_only_today 	= false;
$data_extraction 	= proradio_extract_schedule_days( $schedulefilter, $return_only_today ); // $schedulefilter, $today []
$schedules 			= $data_extraction[ 'posts' ];
$current_day_id 	= $data_extraction[ 'current_day_id' ];


if( 0 == count( $schedules )){
	echo esc_html__( 'No schedules selected', 'proradio' );
}


/**
 * ================================================
 * Array of entities
 * ================================================
 */
$schedulesarray = [];
foreach ( $schedules as $schedule ) {
	$schedulesarray[ $schedule->ID ] = array(
		'title' => $schedule->post_title,
		'unique_schedule_id'=>'proradio-shortcodeschedule-'.$schedule->ID,
		'post' => $schedule,
		'active' => ($current_day_id == $schedule->ID)? 1 : 0
	);
}


$css_classes = array( $schedule_template, $schedule_switch, $schedule_style );

$grid_id = 'proradio-qt-schedule-'.md5( serialize($schedulefilter) ).'-'.get_the_ID();
remove_query_arg( 'scheduleday_is_active' );

?>
<div id="<?php echo esc_attr($grid_id); ?>" class="proradio-schedule proradio-container <?php echo esc_attr( implode(' ', $css_classes ) ); ?> " data-proradio-autorefresh>
	<div class="proradio-program proradio-tabs" data-proradio-tabs>
		
		<div class="proradio-schedule__header">
		
		
			<?php 
			/**
			 * ================================================
			 * Tabs
			 * ================================================
			 */
			if( count( $schedulesarray ) >= 1  ){
				?>
				<a href="#" class="proradio-btn proradio-btn-primary proradio-btn__full proradio-tabs__switch" data-proradio-switch="open" data-proradio-target="#proradio-tabslist"><?php esc_html_e("Select", 'proradio'); ?> <i class="material-icons">arrow_drop_down</i></a>
				
				<ul id="proradio-tabslist" class="proradio-tabs__menu proradio-paper proradio-card">
					<?php  
					foreach( $schedulesarray as $id => $p ){
						$active = '';
						if($p['active'] == 1){
							$active = 'proradio-active';
						}
						?>
						<li><a href="#<?php echo esc_attr( $p['unique_schedule_id'] ); ?>" class="proradio-btn <?php echo esc_attr($active); ?>" data-proradio-switch="open" data-proradio-target="#proradio-tabslist"><?php echo esc_html(  $p['title'] ); ?></a></li>
						<?php
					}
					?>
				</ul>

				<?php
			}
			?>
			<?php if( $schedule_switch ){ ?>
			<a href="#" class="proradio-btn proradio-btn__r proradio-schedule__transform proradio-btn-primary" data-proradio-switch="proradio-schedule--row" data-proradio-target=".proradio-schedule"><i></i></a>
			<?php } ?>
		</div>

		<?php

		/**
		 * ================================================
		 * Tabs Content
		 * ================================================
		 */
		foreach ($schedulesarray as $schedule_id => $p ) {
			?>
			<div id="<?php echo esc_attr( $p['unique_schedule_id'] ); ?>" class="proradio-tabs__content">
				<h3 class="proradio-schedule__dayname"><?php echo esc_html(  $p['title'] ); ?></h3>
				<?php 
				$post = $p['post'];
				set_query_var( 'scheduleday_is_active', 0 );
				if($p['active'] == 1){
					set_query_var( 'scheduleday_is_active', 1 );
				}
				
				setup_postdata( $post );
				get_template_part ('template-parts/schedule/schedule-day',null,$args);
				wp_reset_postdata();
				?>
			</div>
			<?php
		}

		?>
	</div>
</div>