<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 2.0.6.1
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
get_header(); 
?>
<div id="proradio-pagecontent" class="proradio-pagecontent proradio-single proradio-single--podcast">
	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
		<?php 
		/**
		 * ======================================================
		 * Page header template
		 * ======================================================
		 */
		set_query_var( 'proradio_header_wavescolor', get_theme_mod( 'proradio_paper', '#ffffff' ) ) ; // set waves color
		get_template_part( 'template-parts/pageheader/pageheader-podcast' ); 
		?>
		<div class="proradio-maincontent">
			<div class="proradio-section proradio-paper">
				<div class="proradio-container">

					<?php 
					 /*=================================================
					 * 
					 * Pro Radio Business Suite Output
					 * 
					 =================================================*/
					if(function_exists('prbt_create_adslot')){
						echo prbt_create_adslot('prbt-adslot-2');
					}

					?>
					
					<div class="proradio-featuredcontent">

						<?php 
						/**
						* Display featured image if enabled
						* @since 2.0.6.1
						*/
						get_template_part( 'template-parts/single/featured-image' );
						?>



						<?php 

						//======================= PLAYER ======================
						$link = false;//esc_url( get_post_meta( $post->ID, '_podcast_resourceurl' ,true ) );

						$_podcast_resourceurl = get_post_meta( intval($post->ID), '_podcast_resourceurl' ,true );
						if(is_numeric($_podcast_resourceurl)){
							$_podcast_resourceurl = wp_get_attachment_url( intval( $_podcast_resourceurl ) );
						} 
						
						if( $_podcast_resourceurl ){
							$_podcast_resourceurl = esc_url($_podcast_resourceurl );
							$link = $_podcast_resourceurl;
						}



						// Find the classic Enclosure field
						if($link == ''){
							$link = get_post_meta( $post->ID, 'enclosure' ,true ) ;
						}
						// Find the first field containing the Enclosure word
						if($link==''){
							$all_metas = get_post_meta( $post->ID ) ;
							$key = preg_grep('/enclosure/', array_keys($all_metas));
							if( $key ){
								$value = $all_metas[current( $key )];
								if( is_array($value) && count($value) > 0 ){
									$file = $value[0];
									$arr2= explode("\n", $file );
									if( count( $arr2) > 1 ){
										$file = $arr2[0]; // should do the trick
									}
									if (strpos($file, '.mp3') !== false) {
									    $link = $file;
									}
								}
							}
						}
						if($link!=''){
							$regex_mp3 = "/\.mp3/";
							if ( preg_match ( $regex_mp3 , $link  ) ) {
								if(function_exists('qtmplayer_create_singletrack')){
									$artist = get_post_meta( $post->ID, '_podcast_artist', true );
									if(!$artist || $artist == ''){
										$artist =  get_the_author_meta('nickname');
									}


									// Download or buy
									$buylink =  get_post_meta(  $post->ID, 'qtmplayer_dll', true);
									if(!$buylink){
										$buylink = get_post_meta( $post->ID, 'buyurl', true );
									}
									$ext = pathinfo($buylink, PATHINFO_EXTENSION);
									if( $ext == 'mp3'){
										$buylink = qtmplayer_create_dllink( $buylink );
									}

									$track = array(
										'img_id' 		=> ( has_post_thumbnail( $post->ID ) ) ? get_post_thumbnail_id( $post->ID ) : false,
										'title'			=> esc_attr( $post->post_title ),
										'artist_name'	=> esc_attr( $artist ),
										'album'			=> get_post_meta( $post->ID, '_podcast_date', true ),
										'buyurl'		=> $buylink,
										'icon'			=> get_post_meta( $post->ID, 'icon', true ),
										'link'			=> get_the_permalink($post->ID),
										'file'			=> $link,
									);
									$player =  qtmplayer_create_singletrack( $track );

									if( $player ){
										echo wp_kses_post( $player );
										/**
										 * Display the tracklist below the player
										 * @var array
										 */
										$atts = array(
											'file' => $link, /* @since PR.3.9.4 [2022 03 23] */
											'id' => $post->ID ,
											'title_classes'	=> false,
											'classes' => 'qtmplayer-tracklist__autogenerated qtmplayer-tracklist__after', // additional container classes
											'print' => false // include the echo function
										);
										if(function_exists('qtmplayer_tracklist')) {
											echo qtmplayer_tracklist( $atts );
										}
										?>
										<hr class="proradio-spacer-xxs">
										<?php
									}
								} else {
									echo esc_html__( 'Missing QtMusicPlayer plugin', 'proradio' );
								}
							} else {
								// If is not MP3 we rely on the javascript autoembed of the theme
								?>
								<div data-autoembed="<?php echo esc_url( $link ); ?>"></div>
								<?php  
							}
						}
						?>
					</div>
					<div class="proradio-entrycontent">
						<div class="proradio-the_content">

							

							<?php 
							/**
							 * Editor content
							 */
							the_content();
							
							/**
							 * Taxonomy output
							 */
							$tags = proradio_postcategories( 20, 'podcastfilter', false );
							if( $tags ){
								?>
								<hr class="proradio-spacer-s">
								<p class="proradio-tags">
								<?php echo wp_kses_post( $tags ); ?>
								</p>
								<?php 
							}

							/**
							 * Post footer with share
							 */
							get_template_part( 'template-parts/single/part-content-footer' );

							
							?>
						</div>
					</div>

					<?php 
					 /*=================================================
					 * 
					 * Pro Radio Business Suite Output
					 * 
					 =================================================*/
					if(function_exists('prbt_create_adslot')){
						echo prbt_create_adslot('prbt-adslot-8');
					}

					?>
					
				</div>
			</div>
			<?php 
			/**
			 * Related
			 */
			if( get_theme_mod( 'related_podcast' )){
				get_template_part( 'template-parts/single/part-related-podcast' ); 
			}
			?>
		</div>
	<?php endwhile; endif; ?>
</div>
<?php 
get_footer();