<?php  
/**
 * @package proradio
 * @version 2.0
 * Proxy switch
 * 
 **/
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}



/**
* ======================================
* proxy switch
* this switch is in the Welcome page
* ======================================
*/
if ( ! function_exists( 'proradio_proxy_switcher' ) ) {
	add_action( 'admin_init', 'proradio_proxy_switcher' );	
	function proradio_proxy_switcher() {
		if( isset( $_GET ) && isset( $_POST ) ){
			if( isset( $_GET[ 'proradio-proxy-switch' ] ) && isset( $_POST[ 'proradio-proxy-status' ] ) ){
				if ( wp_verify_nonce( $_POST[ 'proradio_disable_switch_field' ], 'proradio_proxy_action') ) {
					if( $_POST[ 'proradio-proxy-status' ] == '0') {
						$val = '0';
					} else {
						$val = '1';
					}
					update_option( 'proradio_proxy_switcher', $val );
				}	
			}
		}
	}
}


/**
* ======================================
* Output the switch in the Welcome page
* ======================================
*/
if ( ! function_exists( 'proradio_proxy_switch_page' ) ) {
	function proradio_proxy_switch_page() {
		?>
		<div class="proradio-welcome proradio-welcome__page">
			<div class="proradio-welcome__container">
				<div class="proradio-welcome__defaultcontainer">
					<h3><?php esc_html_e('Service proxy', 'proradio'); ?></h3>
					<p><?php esc_html_e('In case of activation issues, or CURL failure in server check, you can try to use our proxy connection. Once enabled, the connections to our server will be routed through an alternative path.', 'proradio'); ?></p>
					<form method="post" action="<?php echo admin_url() . 'admin.php?page=proradio-proxy&proradio-proxy-switch=1#proradio-proxyswitch'; ?>" id="proradio-proxyswitch">
						<?php 
						wp_nonce_field( 'proradio_proxy_action', 'proradio_disable_switch_field' );
						if( get_option( 'proradio_proxy_switcher' ) ){
							
							?>
							<p><?php 
							  esc_html_e('The proxy is:','proradio'); echo ' '; esc_html_e('enabled','proradio');
							?></p>
							<input type="hidden" name="proradio-proxy-status" id="proradio-proxy-status" value="0">
							<p><input type="submit" name="submit" value="<?php esc_html_e('Disable service proxy', 'proradio'); ?>"  class="proradio-btn button button-error"></p>
							<?php  
						} else {
							?>
							<p><?php 
							 esc_html_e('The proxy is:','proradio'); echo ' '; esc_html_e('disabled','proradio');
							?></p>
							<input type="hidden" name="proradio-proxy-status" id="proradio-proxy-status" value="1">
							<p><input type="submit" name="submit" value="<?php esc_html_e('Enable service proxy', 'proradio'); ?>"  class="proradio-btn button button-primary"></p>
							<?php  
						}
						?>
					</form>
				</div>
			</div>
		</div>
		<?php 
	}
}



