<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/**
 * =====================================================
 * Desktop
 * =====================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'offcanvas_styling_1',
    'label'       => '',
    'section'     => 'proradio_offcanvas_sidebar',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Desktop', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'offcanvas_styling_1b',
    'label'       => '',
    'section'     => 'proradio_offcanvas_sidebar',
    'default'     =>  '<p>'. esc_html__( 'In mobile is always visible', "proradio" ).'</p>',
) );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'offcanvas_enabled_desktop',
	'label'       => esc_html__( 'Enable Off Canvas sidebar on desktop', 'proradio' ),
	'section'     => 'proradio_offcanvas_sidebar',

	'transport'   => 'auto',
	'default'     => 'inline-flex',
	'multiple'    => false,
	'choices'     => array(
			'inline-flex' 	=> esc_attr__( 'Yes', 'proradio' ),
			'none'   	=> esc_attr__( 'No', 'proradio' ),
			
		),
	'output'    => array(
		array(
			'element'       => '.proradio-menubtns__c [data-proradio-switch="proradio-overlayopen"]',
			'property'      => 'display',
			'media_query' => '@media (min-width: 1200px)'
		),
	),
));


/**
 * =====================================================
 * Styling
 * =====================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'offcanvas_styling_2',
    'label'       => '',
    'section'     => 'proradio_offcanvas_sidebar',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Design', "proradio" ).'</h2>',
) );




Kirki::add_field( 'proradio_config', array(
	'type'        => 'text',
	'settings'    => 'offcanvas_text',
	'label'       => esc_html__( 'Button text', 'proradio' ),
	'section'     => 'proradio_offcanvas_sidebar',
	'default'     => '',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-overlayopen-menu span::after',
			'property'      => 'content',
			'value_pattern' => '"'.esc_html( '$' ).'"',
		),
	),
));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'offcanvas_anim',
	'label'       => esc_html__( 'Entrance animation', 'proradio' ),
	'section'     => 'proradio_offcanvas_sidebar',
	'default'     => 'proradio-overlay--default',
	'multiple'    => false,
	'choices'     => array(
			'proradio-overlay--default' 	=> esc_attr__( 'Slide in', 'proradio' ),
			'proradio-overlay--fadein'   	=> esc_attr__( 'Fade in', 'proradio' ),
		),
));




/**
 * Layout
 * ============================================================ */
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'oc_width',
	'label'       => esc_html__( 'Maximum width', 'proradio' ),
	'section'     => 'proradio_offcanvas_sidebar',
	'default'     => 420,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 300,
		'max'  => 5000,
		'step' => 20,
	],
	'output'    => array(
		
		array(
			'element'       => '.proradio-overlay',
			'property'      => 'width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 670px)'
		),

		
	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'oc_blur',
	'label'       => esc_html__( 'Blur backgorund', 'proradio' ),
	'section'     => 'proradio_offcanvas_sidebar',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 30,
		'step' => 1,
	],
	'output'    => array(
		
		array(
			'element'       => '.proradio-overlay',
			'property'      => 'backdrop-filter',
			'value_pattern' => esc_attr( 'blur( $px );' ),
		),

		
	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'offcanvas_padding',
	'label'       => esc_html__( 'Padding', 'proradio' ),
	'section'     => 'proradio_offcanvas_sidebar',
	'default'     => 0,
	'transport'   => 'auto',
	'default'     => [
		'padding-top'    => '30px',
		'padding-bottom' => '30px',
		'padding-left'   => '30px',
		'padding-right'  => '30px',
	],
	'output'      => array(
		array(
		  'choice'      => 'padding-top',
		  'element'     => '.proradio-overlay',
		  'property'    => 'padding-top',
		  'media_query' => '@media (min-width: 1200px)'
		),
		array(
		  'choice'      => 'padding-bottom',
		  'element'     => '.proradio-overlay',
		  'property'    => 'padding-bottom',
		  'media_query' => '@media (min-width: 1200px)'
		),
		array(
		  'choice'      => 'padding-left',
		  'element'     => '.proradio-overlay',
		  'property'    => 'padding-left',
		  'media_query' => '@media (min-width: 1200px)'
		),
		array(
		  'choice'      => 'padding-right',
		  'element'     => '.proradio-overlay',
		  'property'    => 'padding-right',
		  'media_query' => '@media (min-width: 1200px)'
		),
	),

] );



Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'oc_bg',
	'label'       => esc_html__( 'Background', "proradio" ),
	'section'     => 'proradio_offcanvas_sidebar',
	'transport'   => 'auto',
	'priority'    => 0,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay.proradio-paper',
			'property'      => 'background-color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'oc_color',
	'label'       => esc_html__( 'Text', "proradio" ),
	'section'     => 'proradio_offcanvas_sidebar',
	'transport'   => 'auto',
	'priority'    => 0,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay.proradio-paper',
			'property'      => 'color',
		),
		array(
			'element'       => '.proradio-overlay.proradio-paper h1, .proradio-overlay.proradio-paper h2, .proradio-overlay.proradio-paper h3, .proradio-overlay.proradio-paper h4, .proradio-overlay.proradio-paper h5, .proradio-overlay.proradio-paper h6',
			'property'      => 'color',
		),
	),
));


/**
 * =====================================================
 * Desktop
 * =====================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'offcanvas_styling_3',
    'label'       => '',
    'section'     => 'proradio_offcanvas_sidebar',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Radio channels', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'radiochannel_oc_desktop',
	'label'       => esc_html__( 'Add radio channels to menu', "proradio" ).' '.esc_html__( 'Desktop', "proradio" ),
	'section'     => 'proradio_offcanvas_sidebar',
	'description' => esc_html__( 'Output a playable list of radio channels in the menu', "proradio" ),

));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'radiochannel_oc_mob',
	'label'       => esc_html__( 'Add radio channels to menu', "proradio" ).' '.esc_html__( 'mobile', "proradio" ),
	'section'     => 'proradio_offcanvas_sidebar',
	'description' => esc_html__( 'Output a playable list of radio channels in the menu', "proradio" ),

));


