<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/* = Footer section
=============================================*/



Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'pr_footer_caption_text',
	'section'     => 'proradio_footer_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Content settings', 'proradio').'</h2>',
] );
// copyright bar
Kirki::add_field( 'proradio_config', array(
	'type'        => 'code',
	'settings'    => 'proradio_footer_text',
	'label'       => esc_html__( 'Copyright text content', "proradio" ),
	'section'     => 'proradio_footer_section',
	'choices'     => [
		'language' => 'html',
	],
	'priority'    => 10
));





/**
 * ===============================================
 * MOBILE 
 * ===============================================
 * */
Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'pr_footer_caption_mobile',
	'section'     => 'proradio_footer_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Default settings', 'proradio').'</h2>',
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'copyright_lh',
	'label'       => esc_html__( 'Line height', 'proradio' ).' - '.esc_html__( 'mobile', 'proradio' ),
	'section'     => 'proradio_footer_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0.7,
		'max'  => 6,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-footer__copy p',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $em;' ),
		),
	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'copyright_menu_lh',
	'label'       => esc_html__( 'Line height', 'proradio' ).' '.esc_html__( 'menu', 'proradio' ).' - '.esc_html__( 'mobile', 'proradio' ),
	'section'     => 'proradio_footer_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0.7,
		'max'  => 6,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menubar__footer, .proradio-menubar__footer li',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $em;' ),
		),
	),
] );








/**
 * ===============================================
 * DESKTOP 
 * ===============================================
 * */

Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'pr_footer_caption_desktop',
	'section'     => 'proradio_footer_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Desktop - only settings', 'proradio').'</h2><p>'.esc_html__('Override global settings above 1200px', 'proradio').'</p>',
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'copyright_maxwidth',
	'label'       => esc_html__( 'Maximum width', 'proradio' ),
	'section'     => 'proradio_footer_section',
	'transport'   => 'auto',
	'default'	  => 1170,
	'choices'     => [
		'min'  => 1000,
		'max'  => 5000,
		'step' => 20
	],
	'output'    => array(
		array(
			'element'       => '.proradio-footer .proradio-container',
			'property'      => 'max-width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'copyright_lh_desk',
	'label'       => esc_html__( 'Line height', 'proradio' ).' - '.esc_html__( 'desktop', 'proradio' ),
	'section'     => 'proradio_footer_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0.7,
		'max'  => 6,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-footer__copy p',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $em;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'copyright_menu_lh_desk',
	'label'       => esc_html__( 'Line height', 'proradio' ).' '.esc_html__( 'menu', 'proradio' ).' - '.esc_html__( 'desktop', 'proradio' ),
	'section'     => 'proradio_footer_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0.7,
		'max'  => 6,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menubar__footer, .proradio-menubar__footer li',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $em;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),
] );













/**
 * =========================================================
 * COLORS
 * ========================================================= 
 */


Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'pr_footer_caption_colors',
	'section'     => 'proradio_footer_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Colors', 'proradio').'</h2>',
] );


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_copy_bg',
	'label'       => esc_html__( 'Copyright bar background color', "proradio" ),
	'section'     => 'proradio_footer_section',
	'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-footer__copy.proradio-primary',
			'property'      => 'background-color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_copy_t',
	'label'       => esc_html__( 'Copyright bar text color', "proradio" ),
	'section'     => 'proradio_footer_section',
	'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-footer__copy.proradio-primary',
			'property'      => 'color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_copy_l',
	'label'       => esc_html__( 'Copyright bar links color', "proradio" ),
	'section'     => 'proradio_footer_section',
	'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-footer__copy.proradio-primary a',
			'property'      => 'color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_copy_lh',
	'label'       => esc_html__( 'Copyright bar links hover color', "proradio" ),
	'section'     => 'proradio_footer_section',
	'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-menubar > li:hover > a > span',
			'property'      => 'color',
		),
	),
));
