/**
 * ===============================================================
 * 
 * Ajax music stats from Qantum Themes SL
 * All rights reserved. This software can only be used within 
 * a Qantum Themes product.
 * 
 * ===============================================================
 * */
(function($){
	$.qtMplayerStats = {
		debug: 0,
		timeoutMin: 1000, // minimum time before tracking
		theTimeout: false,
		// storedPlay: [999999], // store here the actions of the user to avoid duplicated counts
		sendHit: function( obj ){
			var that = $.qtMplayerStats;
			if( 'undefined' !== typeof(that.theTimeout) ){
				clearTimeout( that.theTimeout );
			}
			that.theTimeout = setTimeout(
				function(){
					if( that.debug ){
						console.log('Stats trace');
					}

					if(obj.qtmpid){
						if( that.debug ){
							console.log('Proceed tracing');
						}
						var payload = { 
								action: 'qtmplayer-ajax-hit',
								post_id : obj.qtmpid,
								nonce: qtmplayer_stats_ajax_var.statsnonce
							};
						$.ajax({
							type: 'post',
							url: qtmplayer_stats_ajax_var.url,
							data: payload,
							cache: false,
							success: function (json) {
								if( that.debug ){
									console.log(json);
								}
								var response = $.parseJSON(json);
								if( that.debug ){
									console.log(response);
								}
							},
							error: function (data) {
								if( that.debug ){
									console.log(data);
								}
							},
						});
						clearTimeout( that.theTimeout );
					} else {
						if( that.debug ){
							console.log('Missing ID. Trace failed');
						}
					}
				}
			, that.timeoutMin );
		},
		/**
		 * =======================================
		 * Initialize
		 * =======================================
		 * */
		chart: function(  ) {
			
			if('undefined'=== typeof(Chart)){
				return;
			}
			if($('#qtmplayer-stats-source').length <= 0){
				return;
			}
			const ctx = $('#qtmplayer-chart');
			ctx.attr('height',100);
	

			var data = $.parseJSON( $('#qtmplayer-stats-source').text() );
			var labels = new Array();
			var totals = new Array();
			var unique = new Array();
			$.each( data, function( key, value ) {
				var item = {x: key, y: value};
				labels.push(key);
				totals.push(value.T);
				unique.push(value.U);
			});

			const myChart = new Chart(ctx, {
			    type: 'bar',
			    data: {
			        labels: labels,
			        datasets: [{
			            label: 'Total',
			            data: totals,
			            backgroundColor: [
			                '#595CFF',
			            ],
			            borderWidth: 0,
			            borderRadius:2
			        },
			        {
			            label: 'Unique',
			            data: unique,
			            backgroundColor: [
			                '#f72585',
			            ],
			            borderWidth: 0,
			            borderRadius:2
			        }]
			    },
			    options: {
			    	responsive: true,
			        scales: {
			            y: {
			                beginAtZero: true
			            }
			        }
			    }
			});

		},
	};

	/**====================================================================
	 *
	 *	Page Ready Trigger
	 * 
	 ====================================================================*/
	jQuery(document).ready(function() {
		$.qtMplayerStats.chart();	
		$(window).on('qtAjaxpageLoadEnd', function(){
			$.qtMplayerStats.chart();
		}); 
	});
})(jQuery);