<?php  
/**
 * @package qtmplayer
 * @since 2019 12 29
 */

/**
 * [qtmplayer_create_track_data outputs the data attributes used by the player]
 */
if(!function_exists('qtmplayer_create_track_data')){
	function qtmplayer_create_track_data( $data = array() ) {

		if( count($data) == 0) { 
			return; 
		}



		ob_start();

		/**
		 * ================================================
		 * Depending on login status change the song data 
		 * to prevent access to premium contents
		 * @requires Pro.Radio User Manager
		 * ================================================
		 * */
		
		$blockfile = false;



		// User manager integration
		if(function_exists('qtmplayer_post_is_premium')){
			if( qtmplayer_post_is_premium() ){
				$blocking = 0;
				$required_level = get_option( 'prum-can-listen', 0 );
				$user_level = 1; // Any user
				if(is_user_logged_in()){
					$user_level = 2; // logged user only
				}
				if(qtmplayer_is_premium_active()){
					$user_level = 3; // premium only
				}
				if( $user_level <  $required_level ){
					// $blockfile = QTMPLAYER_URL . '/assets/audio/blank.mp3';
					$blocking = 'block';
					if($required_level == 2){
						?>
						data-qtmplayer-blocking="#prum-modal-login"
						<?php
						$data['blocking'] = "#prum-modal-login";
					}
					if($required_level == 3){
						?>
						data-qtmplayer-blocking="#prum-modal-gopremium"
						<?php
						$data['blocking'] = "#prum-modal-gopremium";
					}
				}


				/**
				 * =============================
				 * prevent download for premium
				 * =============================
				 * */
				// Managed in qtmplayer.php
			}
		}





		$data = array_filter( $data );
		foreach( $data as $key => $val ){
			// Fix data attribute for artist field
			if($key === 'artist_name'){ 
				$key = 'artist'; 
			}
			// if($key === 'file' && $blockfile){ 
			// 	$val = $blockfile;
			// }
			?>
			data-qtmplayer-<?php echo esc_html( $key ); ?>="<?php echo esc_attr( $val ); ?>"
			<?php
		}
		



		echo ob_get_clean();
		return;
	}
}