<?php 
/**
 * @package Pro.Radio Business Tools
 * 
 * Admin Settings
 * 
 * */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! function_exists( 'qtmplayer_settings_page_menu' ) ) {
	add_action( 'admin_menu', 'qtmplayer_settings_page_menu' );
	function qtmplayer_settings_page_menu() {
		add_menu_page(
			'Pro Radio Music Player',
			'Pro Radio Music Player',
			'manage_options',
			'qtmplayer-settings',
			'qtmplayer_settings_page',
			'dashicons-format-audio',
			60 // Order ID
		);
	}	
}


if(!function_exists('qtmplayer_settings_page')){

	function qtmplayer_settings_page() {

		/**
		 *  We check if the use is qualified enough
		 */
		$user = wp_get_current_user();
		$allowed_roles = array( 'administrator' );
		if (!current_user_can('manage_options') || !array_intersect($allowed_roles, $user->roles ) )  {
			wp_die( esc_html__('You do not have sufficient permissions to access this page.' , 'proradio-user-manager') );
		}



		/**
		 * ======================================================================================
		 * 
		 * Form fields
		 * 
		 * ======================================================================================
		 * */

		
		$controls = array();

		$controls[] = array(
			'id' => 'qtmplayer_autoplay_visitor',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Autoplay any user", "qtmplayer" ),
			'description'	=>  esc_html__("Start audio at first click on the page for any non-logged user", "qtmplayer" ),
		);

		$controls[] = array(
			'id' => 'qtmplayer_autoplay_admin',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Autoplay admin", "qtmplayer" ),
			'description'	=>  esc_html__("Start audio at first click for logged-in administrator", "qtmplayer" ),
		);

		
		$controls[] = array(
			'id' => 'qtmplayer_min',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=> esc_html__("Load minified javascript", "qtmplayer" ),
			'description'	=> esc_html__('Improve performance (disable in case of issues)', 'qtmplayer'),
		);

		
		$controls[] = array(
			'id' => 'qtmplayer_debug',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Enable debugger for player", "qtmplayer" ),
			'description'	=>  esc_html__("Open the playlist to see the debug messages", "qtmplayer" ),
		);

		$controls[] = array(
			'id' => 'qtmplayer_waveform',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Display audio waveform", "qtmplayer" ),
			'description'	=> esc_html__('Make sure to disable compression for MP3 Files in your server optimization settings', 'qtmplayer'),
		);
		$controls[] = array(
			'id' => 'qtmplayer_disable_peaks_cache',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Disable waveform cache in database", "qtmplayer" ),
			'description'	=> esc_html__('Will not use the cached peaks of the audio files, instead will regenerated theme every time. Slower. Use in case of problems displaying peaks.', 'qtmplayer'),
		);

		$controls[] = array(
			'id' => 'qtmplayer_peaks_public',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Make 'Audio Peaks Cache' post type visible in admin menu for maintenance purposes", "qtmplayer" ),
			'description'	=> esc_html__('On the left menu you can see and edit the peaks cache for single mp3 files', 'qtmplayer'),
		);	

		$controls[] = array(
			'id' => 'qtmplayer_detailed_waveform',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Use precision waveform", "qtmplayer" ),
			'description'	=> esc_html__('Analyze the audio with greater detail. Uses more data to store the information.', 'qtmplayer'),
		);	

		$controls[] = array(
			'id' => 'qtmplayer_stats_enabled',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Enable stats. Makes use of cookies. This feature is experimental.", "qtmplayer" ),
			'description'	=> esc_html__('Collect anonymous play data in your database. Store unique and repeated play actions for each post.', 'qtmplayer'),
		);
		$controls[] = array(
			'id' => 'qtmplayer_stats_public',
			'type'	=> 'checkbox',
			'default' => false,
			'label'	=>  esc_html__("Make the play statistics public", "qtmplayer" ),
			'description'	=>  esc_html__("If unchecked only admin and authors can see statistics", "qtmplayer" ),
		);			



		/**
		 * =====================================================
		 * Form ouput
		 * =====================================================
		 * */
		if(function_exists('qtmplayer_form_generator')){
			$nonce_action = 'qtmplayer_settings_save';
			$nonce_name = 'qtmplayer_settings_nonce';
			$title = esc_html__("Global settings", "proradio-user-manager");
			?>
				<div class="qtmplayer qtmplayer_settings-framework qtmplayer_settings-optionspage">
					<?php include 'header.php'; ?>
					<?php
					/**
					 * =====================================================
					 * Form
					 * =====================================================
					 * */
					qtmplayer_form_generator( $title, $controls, $nonce_action , $nonce_name); 

					?>
				</div>
			<?php 
		}
		return;	
	}
}

/**
 * =====================================================
 * End of file
 * =====================================================
 * */




