<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorPostMosaic extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-post-mosaic'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Post mosaic', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-post-mosaic';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}
	protected function register_controls() {
		$this->start_controls_section(
			'proradio_elementor_section_query_global',
			[
				'label' => esc_html__( 'Query', 'proradio-elementor' ),
			]
		);
			$this->add_control(
				'tax_filter',
				[
					'label' => esc_html__( 'Category filters', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array('category')
				]
			);
			$this->add_control(
				'tax_filter_exc',
				[
					'label' => esc_html__( 'Exclude by category', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array('category')
				]
			);
		// Fields added by query-fields.php
		$this->end_controls_section();

		$this->remove_control('items_per_page');



	}
	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		if(array_key_exists('tax_filter', $atts)){
			if(is_array($atts['tax_filter'])) {
				$atts['tax_filter'] = implode(',', $atts['tax_filter']);
			}
		}
		if(array_key_exists('tax_filter_exc', $atts)){
			if(is_array($atts['tax_filter_exc'])) {
				$atts['tax_filter_exc'] = implode(',', $atts['tax_filter_exc']);
			}
		}

		if(function_exists('proradio_template_post_mosaic')){
			echo proradio_template_post_mosaic( $atts );
		}
	}
	protected function content_template() {}
}