<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.1
 */
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


$copy_text = get_theme_mod('proradio_footer_text');


/**
 * ======================================================
 * Social icons
 * ------------------------------------------------------
 * Display list of social icon links from customizer
 * ======================================================
 */

if( $copy_text || has_nav_menu( 'proradio_menu_footer' ) ){
	?>	
	<div id="proradio-copybar" class="proradio-footer__copy proradio-primary">
		<div class="proradio-container">
			<?php  

			/**
			 * ======================================================
			 * Copyright text
			 * ======================================================
			 */ 
			
			if( $copy_text ){
				?>
				<p><?php echo wp_kses_post( get_theme_mod('proradio_footer_text') ); ?></p>
				<?php
			}

			/**
			 * ======================================================
			 * Footer menu
			 * ======================================================
			 */ 
			
				?>
				<ul class="proradio-menubar proradio-menubar__footer">
					<?php
					if ( has_nav_menu( 'proradio_menu_footer' ) ) {
						wp_nav_menu( array(
							'theme_location' => 'proradio_menu_footer',
							'depth' => 1,
							'container' => false,
							'items_wrap' => '%3$s'
						));
					}
					?>

					<?php  
					/**
					 * ======================================================
					 * Social icons
					 * ======================================================
					 */ 
					
					if (function_exists( 'proradio_qt_socicons_array' )  && get_theme_mod( 'show_social_footer',1 )){
						$social = proradio_qt_socicons_array();
						krsort($social);
						$icons_amount = 0;
						if(is_array($social)){
							if(count($social)>0){

								 ?>
								 <li class="proradio-menubar__footer__separator"></li>
								 <?php 
								  
								
								
								foreach($social as $var => $val){
									$link = get_theme_mod( 'proradio_social_'.$var );
									if($link){
										?>
										<li class="proradio-social"><a href="<?php echo esc_url($link); ?>" class="qt-disableembedding proradio-soc-icon" target="_blank" aria-label="<?php echo esc_attr( $val ); ?>" ><i class="qt-socicon-<?php echo esc_attr($var); ?> qt-socialicon" aria-hidden="true"></i></a></li>
										<?php
									}
								}
							}
						}
					}
					?>

				</ul>
				<?php  
			
			?>
		</div>
	</div>
	<?php  
}
?>