<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/* = Captions section
=============================================*/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'caption_bg',
	'label'       => esc_html__( 'Caption background', "proradio" ),
	'section'     => 'proradio_captions_section',
	'default'	  => '#1c1c1c',
	'priority'    => 0,
	'transport'   => 'auto',
	'choices'     => [
			'alpha' => true,
		],
	'output'    => array(
		array(
			'element'       => '.proradio-caption::before',
			'property'      => 'border-color',
		),
		array(
			'element'       => '.proradio-caption span::after',
			'property'      => 'background-color',
		),
		array(
			'element'       => '.proradio-caption.proradio-caption--neg span',
			'property'      => 'color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'caption_text',
	'label'       => esc_html__( 'Caption text', "proradio" ),
	'section'     => 'proradio_captions_section',
	'default'	  => '#ffffff',
	'priority'    => 0,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-caption span',
			'property'      => 'color',
		),
		array(
			'element'       => '.proradio-caption.proradio-caption--neg::before',
			'property'      => 'border-color',
		),
		array(
			'element'       => '.proradio-caption.proradio-caption--neg span::after',
			'property'      => 'background-color',
		),
	),
));

/**
 * Customize caption appearance
 * */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'caption_editor',
	'label'       => esc_html__( 'Custom design', "proradio" ),
	'section'     => 'proradio_captions_section',
	'priority'    => 10,
));

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_margin',
	'label'       => esc_html__( 'Bottom margin', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => -1,
		'max'  => 2,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-caption',
			'property'      => 'margin-bottom',
			'value_pattern' => esc_attr( ' $em' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_margin_l',
	'label'       => esc_html__( 'Left margin', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  	=> -2,
		'max'  	=> 2,
		'step' 	=> 0.1,
	],
	'default' 		=> -0.6,
	'output'    	=> array(
		array(
			'element'       => '.proradio-caption span',
			'property'      => 'margin-left',
			'value_pattern' => esc_attr( ' $em' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_decor_rad',
	'label'       => esc_html__( 'Corners', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'default'		=> 0,
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-caption span::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );




Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_skew',
	'label'       => esc_html__( 'Decoration skew', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => -45,
		'max'  => 45,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-caption span::after',
			'property'      => 'transform',
			'value_pattern' => 'skew('.esc_attr( ' $deg' ).')',
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'caption_padding',
	'label'       => esc_html__( 'Padding', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'default'     => 0,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
	'default'     => [
		'padding-top'    => '0.15em',
		'padding-bottom' => '0.15em',
		'padding-left'   => '0.7em',
		'padding-right'  => '0.7em',
	],
	'output'      => array(
		array(
		  'choice'      => 'padding-top',
		  'element'     => '.proradio-caption span',
		  'property'    => 'padding-top',
		),
		array(
		  'choice'      => 'padding-bottom',
		  'element'     => '.proradio-caption span',
		  'property'    => 'padding-bottom',
		),
		array(
		  'choice'      => 'padding-left',
		  'element'     => '.proradio-caption span',
		  'property'    => 'padding-left',
		),
		array(
		  'choice'      => 'padding-right',
		  'element'     => '.proradio-caption span',
		  'property'    => 'padding-right',
		),
	),

] );



Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'caption_border_style',
	'label'       => esc_html__( 'Border', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'default'     => 'archive-sidebar',
	'priority'    => 10,
	'multiple'    => false,
	'transport'   => 'auto',
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
	'choices'     => array(
			'dotted' 	=> esc_attr__( 'Default', 'proradio' ),
			'dashed' 	=> esc_attr__( 'dashed', 'proradio' ),
			'solid' 	=> esc_attr__( 'solid', 'proradio' ),
			'double' 	=> esc_attr__( 'double', 'proradio' ),
			'groove' 	=> esc_attr__( 'groove', 'proradio' ),
			'ridge' 	=> esc_attr__( 'ridge', 'proradio' ),
			'hidden' 	=> esc_attr__( 'hidden', 'proradio' ),
		),
	'output'    => array(
		array(
			'element'       => '.proradio-caption::before',
			'property'      => 'border-style',
			'value_pattern' => esc_attr( '$' ),
		),
	),
) );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_decor_height',
	'label'       => esc_html__( 'Border tall', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 3,
		'step' => 0.05,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-caption::before',
			'property'      => 'height',
			'value_pattern' => esc_attr( ' $em' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_decor_w',
	'label'       => esc_html__( 'Border width', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-caption::before',
			'property'      => 'border-width',
			'value_pattern' => esc_attr( ' $px 0' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'caption_decor_top',
	'label'       => esc_html__( 'Border height', 'proradio' ),
	'section'     => 'proradio_captions_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 120,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-caption::before',
			'property'      => 'top',
			'value_pattern' => esc_attr( ' $%' ),
		),
	),
	'active_callback' => [
		[
			'setting'  	=> 'caption_editor',
			'operator' 	=> '==',
			'value'    	=> true,
		]
	],
] );


