<?php
/**
 * @package Qt VideoGalleries
 * @version  2.0
 */

/**
 * [$args Query arguments]
 * @var array
 */
$args = array(
	'post_type' 			=> 'qtvideo',
	'post_status' 			=> 'publish',
	'suppress_filters' 		=> false,
	'ignore_sticky_posts' 	=> 1,
	'posts_per_page' 		=> $quantity,
	'paged' 				=> 1,
	'orderby' 				=> array ('menu_order' => 'ASC', 'date' => 'DESC')
);



// ========== TAXONOMY FILTERING =================

if( $tax_filter || $tax_filter_exc ){
	$tax_query = array(
		'relation' => 'AND'
	);


	if( $tax_filter  ){
		$tax_filter_array = explode(',', trim($tax_filter) );
		$tax_atts = array();
		
		foreach( $tax_filter_array as $var => $val){
			$tax = explode(':', $val);
			if( array_key_exists(1, $tax)){
				$tax_atts[ trim( $tax[0] ) ] [] = trim( $tax[1] );
			}
		}
		foreach( $tax_atts as $taxname => $termslist ){
			$tax_query[] = array(
				'taxonomy' 	=> trim( $taxname ),
				'field' 	=> 'slug',
				'terms'		=> $termslist,
				'operator'	=> 'IN'
			);
		}
	}

	/**
	 * @since 1.7.0.2
	 * Exclude taxonomy
	 * ================================================================================================================================
	 **/

	if( $tax_filter_exc  ){
		$tax_filter_array_exc = explode(',', trim($tax_filter_exc) );
		$tax_atts_exc = array();
		foreach( $tax_filter_array_exc as $var => $val){
			$tax = explode(':', $val);
			if( array_key_exists(1, $tax)){
				$tax_atts_exc[ trim( $tax[0] ) ] [] = trim( $tax[1] );
			}
		}
		foreach( $tax_atts_exc as $taxname => $termslist ){
			$tax_query[] = array(
				'taxonomy' 	=> trim( $taxname ),
				'field' 	=> 'slug',
				'terms'		=> $termslist,
				'operator'	=> 'NOT IN'
			);
		}
	}
	$args[ 'tax_query'] = $tax_query;
}




/**
 * [$wp_query execution of the query]
 * @var WP_Query
 */
$wp_query = new WP_Query( $args );


$cols_class = '4';
if($columns){
	$cols_class = 12 / intval($columns);
}



?>
<div class="proradio-videogalleries">
	<?php  
	if($showfilters){
	?>
	<div class="proradio-videogalleries__filters">
		<a href="#" data-videogalleries-filter="all"><?php echo esc_html( 'All', 'proradio-videogalleries' ); ?></a>
		<?php  
		/**
		 * Create list of filters to click
		 */
		$filters = array();
		if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
			$post = $wp_query->post;
			setup_postdata( $post );
			$termsArray = get_the_terms( $post->ID, 'vdl_filters' );
	        if(is_array($termsArray)){
	        	foreach($termsArray as $term){
	        		$filters[ $term->term_id ] = $term->name;
	        	}
	        }
		endwhile; endif; 
		$filters = array_unique($filters);
		wp_reset_postdata();

		// Output the filters
		foreach ($filters as $key => $value) {
			?>
			<a href="#" data-videogalleries-filter="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></a>
			<?php
		}


		?>
	</div>
	<?php 
	}
	?>

	<div id="proradio-videogalleries-masonry" class="proradio-videogalleries-masonry proradio-videogalleries-row">
		<?php  
		if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
			$post = $wp_query->post;
			setup_postdata( $post );

			/**
			 * Create filterable data
			 */
			
			$fiters = array();
			$termsArray = get_the_terms( $post->ID, 'vdl_filters' );
			if(is_array( $termsArray )){
				foreach($termsArray as $term){
					$fiters[] = '{'.$term->term_id.'}';
				}
			}
			$fiters_html = implode(',', $fiters);

			?>
				<div data-videogallery-filterids="<?php echo esc_attr($fiters_html); ?>" class="proradio-videogalleries-masonry-item proradio-videogalleries-col proradio-videogalleries-s12 proradio-videogalleries-m4 proradio-videogalleries-l<?php echo esc_attr( $cols_class ); ?> ">
					<?php  
					include (  proradio_videogalleries_local_template_path() . 'qtvideo-item.php' );
					?>
				</div>
			<?php  
		endwhile; else: ?>
			<h3><?php esc_html_e("Sorry, nothing here","proradio"); ?></h3>
		<?php endif;
		wp_reset_postdata();
		?>
	</div>
</div>