<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.3.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorDedicationsList extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-dedications-list'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Dedications list', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-radio-feed';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}

	// Javascript
		/**
	 * @since version PR.2.3.0 loaded from minified scripts.
	 * To unse unminified, edit _plugin.php line 53 $use_minified_script = true;
	 * 
	 * 
	 * */
	 public function __construct($data = [], $args = null) {
      parent::__construct($data, $args);
      wp_register_script( 'proradio-elementor-dedications-list', plugins_url( '/dedications.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
   	}
 	public function get_script_depends() {
	     return [ 'proradio-elementor-dedications-list' ];
	}


	protected function register_controls() {
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Settings', 'proradio-elementor' ),
			]
		);

			$this->add_control(
				'items_per_page',
				[
					'label' => esc_html__( "Number of items", "proradio-elementor" ),
					'type' => Controls_Manager::TEXT,
					'default' => 3
				]
			);

			$this->add_control(
				'autoscroll',
				[
					'label' => esc_html__( 'Automatic scroll', 'proradio-elementor' ),
					'type' => Controls_Manager::SWITCHER,
					'return_value' => 'true',
				]
			);
			

			$this->add_control(
				'duration',
				[
					'label' => esc_html__( 'Animation duration', 'textdomain' ),
					'description' => esc_html__( '1-10 where 10 = slowest', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 30,
					'step' => 1,
					'default' => 6,
					'condition' => array(
				      'autoscroll' => 'true',
				    ),
				]
			);

			$this->add_responsive_control(
				'dedication-maxheight',
				[
					'label' => esc_html__( 'Maximum height', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 50,
							'max' => 1000,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-list ' => 'max-height: {{SIZE}}{{UNIT}}; overflow: auto;',
						'{{WRAPPER}} .proradio-dedications-marquee ' => 'height: {{SIZE}}{{UNIT}}; overflow: hidden;',
					],
				]
			);
			


			
			$this->add_control(
				'dedications-bg',
				[
					'label' => esc_html__( 'Background', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-list' => 'background-color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'proradio-name-background',
				[
					'label' => esc_html__( 'Name background', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ' => '--proradio-colors-primary-light: {{VALUE}}',
					]
				]
			);
			$this->add_control(
				'proradio-name-txt',
				[
					'label' => esc_html__( 'Name text', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ' => '--proradio-colors-primary-text: {{VALUE}}',
					]
				]
			);
			$this->add_control(
				'proradio-txt',
				[
					'label' => esc_html__( 'Text color', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-list' => 'color: {{VALUE}} !important;',
					]
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'proradio-txt-typo',
					'label' => __( 'Typography','proradio-elementor'),
					'scheme' => Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .proradio-dedications-list span, {{WRAPPER}} .proradio-dedications-list a'
				]
			);

			$this->add_responsive_control(
				'dedications-padding',
				[
					'label' => esc_html__( 'Padding', 'elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%', 'rem' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'dedications-radius',
				[
					'label' => esc_html__( 'Border-radius', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 30,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-dedications-list' => 'border-radius: {{SIZE}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
	}

	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		if(function_exists('proradio_dedications_list')){
			echo proradio_dedications_list($atts );
		}
	}
	
	protected function content_template() {}
}