<?php
/**
 * @package proradio-chartvote
 * @author Pro.Radio
 * Creates admin settings page
 */




/**
 * Create options page
 */
add_action('admin_menu', 'qt_chartvote_settings_create_optionspage');
if(!function_exists('qt_chartvote_settings_create_optionspage')){
	function qt_chartvote_settings_create_optionspage() {
		add_options_page('Pro.Radio Chart Settings', 'Pro.Radio Chart Settings', 'manage_options', 'qt_chartvote_settings', 'qt_chartvote_settings_options');
	}
}

/**
 *  Main options page content
 */
if(!function_exists('qt_chartvote_settings_options')){
	function qt_chartvote_settings_options() {
		?>
		<h2>Chart Vote Settings</h2>
		<?php  
		/**
		 *  We check if the use is qualified enough
		 */
		if (!current_user_can('manage_options'))  {
			wp_die( esc_html__('You do not have sufficient permissions to access this page.') );
		}

		/**
		 *  Saving options
		 */
		
		$chackboxes = array(
			"qt_chartvote_settings_enable" => esc_html__("Enable chart voting globally", "proradio-chartvote" ),
			"qt_chartvote_settings_allow_downvote" => esc_html__("Allow downvote", "proradio-chartvote" ),
		);

		if ( ! empty( $_POST ) ) {
			if(!check_admin_referer( 'qt_chartvote_settings_save', 'qt_chartvote_settings_nonce' )){
				echo 'Invalid request';
			} else {

				foreach($textfields as $varname => $label){
					if(isset($_POST[$varname])){
						update_option($varname, wp_kses($_POST[$varname], array() ));
					}
				}

				foreach($chackboxes as $varname => $label){
					if(isset($_POST[$varname])){
						if($_POST[$varname] == 'on'){
							update_option($varname, 1);
						} 
					} else {
						update_option($varname, 0 );
					}
				}
			}
		}

		/**
		 *  Options page content
		 */
		?>
		<div class="proradio_reaktions-framework proradio_reaktions-optionspage">
			<p class="right blue-grey-text lighten-3">V. <?php echo esc_attr(qt_chartvote_plugin_get_version()); ?></p>
			<h2 class="proradio_reaktions-modaltitle"><?php echo esc_attr__("Settings", "proradio-chartvote"); ?></h2>
			<div class="row">
				<form method="post" class="col s12" action="<?php echo esc_url($_SERVER["REQUEST_URI"]); ?>">
					<?php
					foreach($chackboxes as $varname => $label){
					?>
						<p class="row">
							<input id="<?php echo esc_attr($varname); ?>" name="<?php echo esc_attr($varname); ?>"  type="checkbox" <?php if (get_option( $varname, 1)){ ?> checked <?php } ?>>
							<label for="<?php echo esc_attr($varname); ?>"><?php echo esc_attr($label); ?></label>
						</p>
					<?php } ?>
					<?php
					foreach($textfields as $varname => $label){
					?>
						<p class="row">
							<label for="<?php echo esc_attr($varname); ?>"><?php echo esc_attr($label); ?></label>
							<input id="<?php echo esc_attr($varname); ?>" name="<?php echo esc_attr($varname); ?>"  type="text" value="<?php echo esc_attr(get_option( $varname, 120)); ?>">
						</p>
					<?php } ?>
					<?php wp_nonce_field( "qt_chartvote_settings_save", "qt_chartvote_settings_nonce", true, true ); ?>
					<input type="submit" name="submit" value="Save"  class="button button-primary" />
				</form>
			</div>
			
		</div>
		<?php 
	}
}