<?php

defined( 'ABSPATH' ) || exit;


?>

<div class="dracula-getting-started">
    <div class="getting-started-header">

        <div class="header-logo">
            <img src="<?php echo esc_url( DRACULA_ASSETS . '/images/dracula-logo.svg' ); ?>">
            <span><?php _e( 'Dracula Dark Mode', 'dracula-dark-mode' ) ?></span>
        </div>

        <p><?php _e( 'Smooth Dark Mode & Enhanced Accessibility for WordPress', 'dracula-dark-mode' ) ?></p>

        <h2 class="header-title"><?php _e( 'Getting Started', 'dracula-dark-mode' ) ?></h2>

    </div>

    <div class="getting-started-main">

        <div class="getting-started-menu">
            <div class="menu-item active" data-target="introduction">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                          d="M19.6004 9.9999C19.6004 12.546 18.589 14.9878 16.7886 16.7881C14.9883 18.5885 12.5465 19.5999 10.0004 19.5999C7.45431 19.5999 5.01252 18.5885 3.21217 16.7881C1.41182 14.9878 0.400391 12.546 0.400391 9.9999C0.400391 7.45382 1.41182 5.01203 3.21217 3.21168C5.01252 1.41133 7.45431 0.399902 10.0004 0.399902C12.5465 0.399902 14.9883 1.41133 16.7886 3.21168C18.589 5.01203 19.6004 7.45382 19.6004 9.9999V9.9999ZM11.2004 5.1999C11.2004 5.51816 11.074 5.82339 10.8489 6.04843C10.6239 6.27347 10.3187 6.3999 10.0004 6.3999C9.68213 6.3999 9.37691 6.27347 9.15186 6.04843C8.92682 5.82339 8.80039 5.51816 8.80039 5.1999C8.80039 4.88164 8.92682 4.57642 9.15186 4.35137C9.37691 4.12633 9.68213 3.9999 10.0004 3.9999C10.3187 3.9999 10.6239 4.12633 10.8489 4.35137C11.074 4.57642 11.2004 4.88164 11.2004 5.1999ZM8.80039 8.7999C8.48213 8.7999 8.17691 8.92633 7.95186 9.15137C7.72682 9.37642 7.60039 9.68164 7.60039 9.9999C7.60039 10.3182 7.72682 10.6234 7.95186 10.8484C8.17691 11.0735 8.48213 11.1999 8.80039 11.1999V14.7999C8.80039 15.1182 8.92682 15.4234 9.15186 15.6484C9.37691 15.8735 9.68213 15.9999 10.0004 15.9999H11.2004C11.5187 15.9999 11.8239 15.8735 12.0489 15.6484C12.274 15.4234 12.4004 15.1182 12.4004 14.7999C12.4004 14.4816 12.274 14.1764 12.0489 13.9514C11.8239 13.7263 11.5187 13.5999 11.2004 13.5999V9.9999C11.2004 9.68164 11.074 9.37642 10.8489 9.15137C10.6239 8.92633 10.3187 8.7999 10.0004 8.7999H8.80039Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php _e( 'Introduction','dracula-dark-mode') ?></span>
            </div>

            <div class="menu-item" data-target="what-new">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M4.09836 20.4924C3.37761 20.4719 2.78595 20.2061 2.31261 19.6845C1.36595 18.621 0.645201 17.4349 0.161114 16.1259C-0.172369 15.2261 -0.0217641 14.3671 0.752776 13.7536C1.94686 12.8026 1.9361 11.1869 0.752776 10.2461C-0.0217641 9.6121 -0.172369 8.73268 0.171871 7.82258C0.655959 6.53413 1.38747 5.35816 2.32337 4.31513C2.95807 3.60954 3.79715 3.30277 4.73305 3.61977C6.38971 4.17197 7.7344 3.21074 7.99258 1.82003C8.15394 0.940606 8.79939 0.388412 9.7353 0.214573C11.2306 -0.0717499 12.7259 -0.0717499 14.2212 0.204347C15.1894 0.388412 15.781 0.981509 16.0392 1.88138C16.491 3.48684 17.5345 4.05948 19.2234 3.59932C20.2024 3.33345 21.0307 3.58909 21.6869 4.31513C22.6443 5.36839 23.3651 6.56481 23.8384 7.87371C24.1719 8.77358 23.9782 9.58142 23.2467 10.2563C22.0096 11.4016 22.0096 12.5674 23.2575 13.7433C23.9782 14.4182 24.1719 15.2261 23.8491 16.1362C23.3651 17.4655 22.612 18.662 21.6439 19.7254C21.0092 20.4106 20.2024 20.6458 19.2664 20.4003C17.5452 19.9402 16.5018 20.5026 16.0392 22.1387C15.781 23.0488 15.1894 23.6215 14.2212 23.8055C12.7474 24.0714 11.2629 24.0816 9.78908 23.8055C8.82091 23.6215 8.21849 23.0386 7.97106 22.1387C7.53001 20.5333 6.48653 19.9606 4.7976 20.4106C4.56093 20.4515 4.34578 20.5026 4.09836 20.4924ZM16.5233 12.5674C16.5018 12.7412 16.5018 12.8537 16.4803 12.9662C15.8671 15.4715 13.1992 16.9133 10.5959 16.1566C9.76757 15.9214 9.1759 16.1566 8.95 16.8315C8.7456 17.4553 9.1006 18.0075 9.89666 18.2325C12.3063 18.9176 14.5009 18.5086 16.4372 16.9951C18.5887 15.3181 19.4386 12.3731 18.5242 9.91888C18.2122 9.09058 17.3409 8.76336 16.7062 9.2951C15.9424 9.9291 15.2324 10.6347 14.5439 11.3505C14.1674 11.7493 14.2427 12.3628 14.63 12.7412C15.0172 13.1196 15.6304 13.1809 16.1037 12.8844C16.2328 12.8026 16.3512 12.7003 16.5233 12.5674ZM7.47622 11.4221C7.48698 11.2789 7.48698 11.1971 7.49773 11.1153C8.05712 8.60997 10.7357 7.09655 13.3175 7.81236C13.5219 7.87371 13.7263 7.94529 13.9415 7.94529C14.4901 7.96574 14.9742 7.57716 15.0818 7.04542C15.1894 6.51368 14.8559 6.01261 14.2319 5.79787C11.7147 4.90822 8.61651 5.67516 6.82001 7.69987C5.14184 9.59165 4.69002 11.7391 5.48608 14.1012C5.76577 14.9295 6.66941 15.2363 7.3041 14.6943C8.05712 14.0603 8.7456 13.3752 9.43408 12.6798C9.8106 12.2913 9.76757 11.7084 9.42333 11.3198C9.06833 10.921 8.48742 10.8085 8.01409 11.0539C7.85273 11.1357 7.70213 11.2687 7.47622 11.4221Z" fill="#4D4D4D"/>
                </svg>
                <span><?php _e( 'Changelog','dracula-dark-mode') ?></span>
            </div>

            <div class="menu-item" data-target="basic-usage">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12.6562 0.00927734C12.6562 1.6024 12.6562 3.12993 12.6562 4.65746C12.6562 5.41654 12.8719 5.63208 13.6312 5.63208C15.1594 5.63208 16.6875 5.63208 18.2812 5.63208C18.2812 6.63481 18.2906 7.60943 18.2719 8.58405C18.2719 8.70588 18.1125 8.83708 18.0094 8.94953C16.5938 10.3646 15.1875 11.7797 13.7625 13.1854C13.2844 13.6539 12.9375 14.1881 12.75 14.8347C12.5813 15.4158 12.3656 15.9874 12.1875 16.5684C11.9812 17.2432 12.1312 17.8429 12.6281 18.3302C13.1344 18.8269 13.7531 18.9769 14.4375 18.7426C14.5969 18.6864 14.7562 18.6301 14.925 18.5739C16.1437 18.1897 17.4 17.8617 18.2438 16.6059C18.2719 16.8589 18.2906 16.9714 18.2906 17.0932C18.2906 18.6395 18.3 20.1858 18.2906 21.732C18.2812 23.119 17.3906 23.9999 15.9938 23.9999C11.4281 23.9999 6.87188 23.9999 2.30625 23.9999C0.88125 23.9905 0 23.119 0 21.7227C0 15.2471 0 8.76211 0 2.27714C0 0.899554 0.88125 0.00927734 2.24062 0.00927734C5.56875 0.00927734 8.89687 0.00927734 12.225 0.00927734C12.3469 0.00927734 12.4688 0.00927734 12.6562 0.00927734ZM8.42813 8.44348C9.99375 8.44348 11.55 8.44348 13.1156 8.44348C13.7062 8.44348 14.0344 8.19046 14.0438 7.75C14.0531 7.30955 13.7156 7.03778 13.1344 7.03778C9.99375 7.03778 6.85312 7.03778 3.7125 7.03778C3.68437 7.03778 3.64687 7.03778 3.61875 7.03778C3.12187 7.05652 2.80312 7.33766 2.8125 7.75C2.82188 8.1436 3.12188 8.44348 3.6 8.44348C5.2125 8.42474 6.81563 8.44348 8.42813 8.44348ZM6.99375 11.2549C8.11875 11.2549 9.24375 11.2549 10.3687 11.2549C10.9031 11.2549 11.2406 10.9737 11.2313 10.5427C11.2219 10.1303 10.9031 9.84918 10.3969 9.84918C8.14688 9.84918 5.89688 9.84918 3.64688 9.84918C3.14063 9.84918 2.82188 10.121 2.8125 10.5427C2.80312 10.9737 3.14062 11.2549 3.66562 11.2549C4.77187 11.2549 5.8875 11.2549 6.99375 11.2549ZM7.03125 14.0663C8.12813 14.0663 9.21562 14.0663 10.3125 14.0663C10.8938 14.0663 11.2312 13.8039 11.2406 13.3634C11.2406 12.923 10.9031 12.6606 10.3219 12.6606C8.11875 12.6606 5.91562 12.6606 3.7125 12.6606C3.15 12.6606 2.80313 12.9417 2.82188 13.3822C2.83125 13.8133 3.15937 14.0663 3.7125 14.0663C4.80937 14.0663 5.91563 14.0663 7.03125 14.0663ZM6.98438 16.8777C8.10938 16.8777 9.23438 16.8777 10.3594 16.8777C10.9031 16.8777 11.2313 16.6059 11.2313 16.1748C11.2313 15.7438 10.8938 15.472 10.3594 15.472C8.1375 15.472 5.925 15.472 3.70312 15.472C3.14062 15.472 2.79375 15.7531 2.8125 16.1936C2.83125 16.6153 3.15 16.8683 3.70312 16.8777C4.8 16.8777 5.8875 16.8777 6.98438 16.8777ZM11.2406 19.6891C10.5656 19.6891 9.9 19.6797 9.225 19.6891C8.71875 19.6985 8.41875 19.9702 8.42813 20.4013C8.4375 20.8324 8.72812 21.0948 9.24375 21.0948C10.575 21.1042 11.8969 21.1042 13.2281 21.0948C13.725 21.0948 14.0531 20.7949 14.0438 20.3826C14.0344 19.9702 13.7156 19.6985 13.2094 19.6891C12.5531 19.6797 11.8969 19.6891 11.2406 19.6891Z"
                          fill="#4D4D4D"/>
                    <path d="M16.941 15.8562C16.3223 15.2377 15.6754 14.5911 15.0566 13.9819C16.5473 12.4919 18.066 10.9737 19.5473 9.50244C20.1473 10.1022 20.8035 10.7582 21.4223 11.3861C19.9598 12.8386 18.4316 14.3662 16.941 15.8562Z"
                          fill="#4D4D4D"/>
                    <path d="M14.0625 4.1796C14.0625 2.80201 14.0625 1.4338 14.0625 0.0374698C14.5781 -0.0281296 15.2719 -0.0375009 15.6281 0.290496C16.4625 1.06832 17.1094 1.78054 17.8688 2.63333C18.1594 2.96133 18.2906 3.2987 18.2906 4.1796C16.7531 4.1796 15.4688 4.1796 14.0625 4.1796Z"
                          fill="#4D4D4D"/>
                    <path d="M20.6621 8.26564C20.9715 7.96576 21.309 7.58154 21.7027 7.25354C22.2652 6.78497 23.1371 6.85994 23.6152 7.36599C24.1121 7.89079 24.1402 8.66861 23.6434 9.23089C23.3152 9.60575 22.9309 9.92437 22.6027 10.2524C21.984 9.61512 21.3465 8.95912 20.6621 8.26564Z"
                          fill="#4D4D4D"/>
                    <path d="M14.0909 15.2002C14.6344 15.7531 15.1498 16.2685 15.6934 16.8214C15.103 17.0182 14.5032 17.2431 13.8847 17.4212C13.5848 17.5055 13.4161 17.215 13.538 16.8496C13.716 16.2966 13.9128 15.7531 14.0909 15.2002Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php _e( 'Basic Usage','dracula-dark-mode') ?></span>
            </div>

            <div class="menu-item" data-target="help">

                <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_1447_16453)">
                        <path d="M11.9885 0C17.5481 0.028766 22.387 3.87191 23.6682 9.30868C25.2068 15.8271 21.2431 22.3109 14.7454 23.8643C12.2631 24.4569 9.82075 24.2555 7.45278 23.2832C7.25259 23.2027 7.07528 23.1797 6.85221 23.2429C5.09625 23.732 3.34029 24.198 1.58433 24.6697C0.857928 24.8711 0.228757 24.5086 0.074324 23.7722C0.0342858 23.5709 0.074324 23.335 0.131521 23.1279C0.560501 21.4767 1.00092 19.8313 1.4299 18.1801C1.46422 18.0536 1.45278 17.8925 1.39558 17.7774C0.663457 16.3909 0.200158 14.9181 0.0571648 13.3647C-0.251701 9.97606 0.646297 6.94412 2.83124 4.32641C4.70731 2.08266 7.1096 0.71915 9.97518 0.207115C10.6387 0.0920513 11.3193 0.0690385 11.9885 0ZM2.47089 22.3052C4.0095 21.8852 5.47375 21.494 6.93228 21.0912C7.21827 21.0107 7.4585 21.0337 7.72733 21.166C9.83219 22.1671 12.0343 22.3972 14.2879 21.8679C19.4699 20.6483 22.7473 15.5509 21.7807 10.2522C20.8084 4.89022 15.6206 1.28296 10.2783 2.25526C7.63581 2.73277 5.51379 4.07327 3.94086 6.24798C2.30502 8.50324 1.75021 11.0462 2.18491 13.8019C2.3851 15.0561 2.83124 16.2355 3.49472 17.3229C3.632 17.5473 3.67204 17.7716 3.59768 18.0305C3.34601 18.9395 3.1115 19.8543 2.87127 20.7691C2.73972 21.2581 2.61389 21.7529 2.47089 22.3052Z"
                              fill="#4D4D4D"/>
                        <path d="M9.79738 9.80903C9.09386 9.72273 8.41893 9.63643 7.6582 9.53863C7.76116 9.14741 7.81264 8.74469 7.96707 8.39374C8.53332 7.11078 9.54572 6.36861 10.907 6.11547C11.9423 5.91986 12.9776 5.96014 13.9613 6.35135C15.1511 6.82887 15.9976 7.64583 16.255 8.95756C16.438 9.91259 16.152 10.7468 15.4828 11.4257C14.9509 11.9722 14.3732 12.4728 13.8069 12.9848C13.3779 13.3703 13.0062 13.7787 12.989 14.4001C12.9833 14.6187 12.9718 14.8373 12.9604 15.0732C12.274 15.0732 11.6048 15.0732 10.9013 15.0732C10.8384 14.0491 10.8784 13.0481 11.6449 12.2656C12.2569 11.6385 12.949 11.092 13.5838 10.4879C14.2416 9.86081 14.2416 8.92304 13.5724 8.30744C12.9432 7.72637 12.1882 7.68034 11.4046 7.87595C10.5867 8.08307 10.1463 8.68716 9.90034 9.45233C9.8603 9.55589 9.83742 9.67095 9.79738 9.80903Z"
                              fill="#4D4D4D"/>
                        <path d="M10.9199 15.9077C11.6864 15.9077 12.4242 15.9077 13.1792 15.9077C13.1792 16.6614 13.1792 17.4093 13.1792 18.1745C12.4357 18.1745 11.6921 18.1745 10.9199 18.1745C10.9199 17.4323 10.9199 16.6786 10.9199 15.9077Z"
                              fill="#4D4D4D"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_1447_16453">
                            <rect width="24" height="24.7273" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>

                <span><?php _e( 'Help','dracula-dark-mode') ?></span>
            </div>

			<?php if ( ddm_fs()->is_not_paying() ) { ?>
                <div class="menu-item" data-target="get-pro">
                    <svg width="24" height="18" viewBox="0 0 24 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_1126_11058)">
                            <path d="M11.979 12.8946C8.62624 12.8946 5.27345 12.8849 1.93067 12.9044C1.54034 12.9044 1.44026 12.7877 1.39021 12.4279C0.949848 9.57859 0.489464 6.73904 0.0290807 3.89949C-0.0409777 3.48134 -0.0309694 3.11181 0.379373 2.87842C0.75969 2.65476 1.09997 2.7909 1.43025 3.03402C2.83142 4.06481 4.2526 5.0956 5.66378 6.11667C6.39438 6.64179 6.97487 6.54455 7.47529 5.81521C8.65627 4.09398 9.83725 2.37275 11.0182 0.651519C11.6187 -0.223683 12.3794 -0.223683 12.9899 0.651519C14.1609 2.3533 15.3318 4.06481 16.5028 5.76659C17.0433 6.55427 17.5937 6.65152 18.3744 6.0875C19.7755 5.07615 21.1767 4.06481 22.5679 3.03402C22.8981 2.7909 23.2384 2.65476 23.6187 2.87842C24.0291 3.11181 24.0391 3.48134 23.969 3.89949C23.5787 6.32089 23.1984 8.75201 22.8081 11.1734C22.738 11.6207 22.6379 12.0681 22.6079 12.5154C22.5779 12.8946 22.3577 12.8946 22.0674 12.8946C18.7147 12.8946 15.3418 12.8946 11.979 12.8946Z"
                                  fill="#4D4D4D"/>
                            <path d="M12.0006 14.5771C15.3333 14.5771 18.6661 14.5868 21.9989 14.5674C22.4593 14.5674 22.5594 14.6938 22.5293 15.112C22.4893 15.7051 22.5293 16.3081 22.5193 16.911C22.5093 17.5722 22.119 17.9612 21.4484 18.0098C21.3283 18.0196 21.2182 18.0196 21.0981 18.0196C15.0331 18.0196 8.95803 18.0196 2.89298 18.0196C2.72284 18.0196 2.5627 18.0196 2.39256 17.9904C1.85211 17.9126 1.49181 17.5431 1.4718 17.0082C1.45178 16.3761 1.49181 15.744 1.45178 15.112C1.43176 14.7035 1.52184 14.5674 1.98222 14.5674C5.33501 14.5868 8.66779 14.5771 12.0006 14.5771Z"
                                  fill="#4D4D4D"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_1126_11058">
                                <rect width="24" height="18" fill="white"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <span><?php _e( 'Get PRO','dracula-dark-mode') ?></span>
                </div>
			<?php } ?>

        </div>

		<?php include_once DRACULA_INCLUDES . '/views/getting-started/introduction.php'; ?>
		<?php include_once DRACULA_INCLUDES . '/views/getting-started/what-new.php'; ?>
		<?php include_once DRACULA_INCLUDES . '/views/getting-started/basic-usage.php'; ?>
		<?php include_once DRACULA_INCLUDES . '/views/getting-started/help.php'; ?>

		<?php
		if ( ddm_fs()->is_not_paying() ) {
			include_once DRACULA_INCLUDES . '/views/getting-started/get-pro.php';
		}
		?>

    </div>

</div>

<script>
    jQuery(document).on('ready', function () {
        jQuery('.dracula-getting-started .menu-item').on('click', function () {
            const target = jQuery(this).data('target');

            jQuery('.menu-item').removeClass('active');
            jQuery('.getting-started-content').removeClass('active');

            jQuery(this).addClass('active');
            jQuery('#' + target).addClass('active');
        });
    });
</script>