<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $el_id
 * @var $width
 * @var $css
 * @var $offset
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Column_Inner
 */
$el_class = $width = $el_id = $css = $offset = '';
$output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$width = wpb_translateColumnWidthToSpan( $width );
$width = vc_column_offset_class_merge( $offset, $width );

/**
 * proradio columns width fix tablet
 */
$proradio_cols_array = explode( ' ', $width );
foreach( $proradio_cols_array as $ttg_cols_class ){
	if ( strpos( $ttg_cols_class, 'vc_col-md-' ) !== false ) {
		$ttg_colwidth = str_replace( 'vc_col-md-', '', $ttg_cols_class ); // width for horizontal tablet
		$width = str_replace('vc_col-sm-', 'vc_col-sm-nul-', $width) . ' vc_col-sm-' . $ttg_colwidth;  
	}
}

$css_classes = array(
	$this->getExtraClass( $el_class ),
	'wpb_column',
	'vc_column_container',
	$width,
);

if ( vc_shortcode_custom_css_has_property( $css, array(
	'border',
	'background',
) ) ) {
	$css_classes[] = 'vc_col-has-fill';
}

$wrapper_attributes = array();

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
$innerColumnClass = 'vc_column-inner ' . esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) );
	$output .= '<div class="' . trim( $innerColumnClass ) . '">';
		$output .= '<div class="wpb_wrapper">';
		$output .= wpb_js_remove_wpautop( $content );
		$output .= '</div>';
	$output .= '</div>';
$output .= '</div>';

echo $output;
