<?php
/**
 * Related posts
 * 
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.0
*/

$postid = get_the_id();
$related_posttype = get_post_type( $postid );
$related_taxonomy =  proradio_get_type_taxonomy( $related_posttype ) ;



$related_posts_per_page = 3;

/**
 *
 *  Basic query preparation
 *  
 */
$previous_post = get_previous_post();
if($previous_post && !is_wp_error( $previous_post )){
	$argsList = array(
		'post_type' => $related_posttype,
		'posts_per_page' => $related_posts_per_page,
		'ignore_sticky_posts' => 1,
		'orderby' => array(  'menu_order' => 'ASC' ,    'post_date' => 'DESC'),
		'post_status' => 'publish',
		'post__not_in'=> array(get_the_id())
	);

	/**
	 *
	 *  If this post is in a serie we try to get the posts
	 *  in the same serie, otherwise in same category.
	 *  
	 */

	$term_ids = false;
	$terms = get_the_terms( $postid  , $related_taxonomy, 'string');



	// Add taxonomy query arguments
	if( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		if(is_array($terms)) {
			$term_ids = wp_list_pluck($terms,'term_id');
			if ($term_ids) {
				$argsList['tax_query'] =  array(
					array(
						'taxonomy' => $related_taxonomy,
						'field' => 'id',
						'terms' => $term_ids,
						'operator'=> 'IN'
					)
				);
			}
		}
	}



	/**
	 *
	 *  Custom related
	 *  *edit 2023 04 28
	 */
	$custom_related = get_post_meta( get_the_id(), 'custom_related_posts',  true );
	if($custom_related){
		if(count($custom_related) > 0){
			$list = [];
			foreach( $custom_related as $related => $id){
				if($id['custom_related_posts'][0]){
					$list[] = $id['custom_related_posts'][0];
				}
			}
			if($list){
				$argsList = array(
					'post__in' => $list,
			        'orderby' => 'ID',
			        'post_type' => 'any'
				);
			}
		}
	}


	/**
	 * 
	 * Execute query
	 * 
	 */
	$the_query = new WP_Query($argsList);
	if ( $the_query->have_posts() ) :
		if( $the_query->post_count > 0 ){
			?>
			<div class="proradio-related proradio-primary-light proradio-section proradio-negative">
				<div class="proradio-container">
					<?php  
					if( function_exists('proradio_template_caption') ){
						echo proradio_template_caption( array( 'title' => esc_html__( 'You may also like', 'proradio'), 'alignment' => 'center', 'negative' => true, 'size' => 'm', 'anim' => 1 ) );
					}
					?>
					<hr class="proradio-spacer_m">
					<div class="proradio-row ">
						<?php 
						while ( $the_query->have_posts() ) : $the_query->the_post(); 
							$post = $the_query->post;
							setup_postdata( $post );
							
							?>
							<div class="proradio-col proradio-s12 proradio-m6 proradio-l4">
								<?php get_template_part ('template-parts/post/post-podcast'); ?>
							</div>
							<?php
						endwhile;
						?>
					</div>
				</div>
			</div>
			<?php  
		}
	endif;
}
wp_reset_postdata();
