<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.5.4
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * ======================================================
 * HTML output starts here
 * ======================================================
 */

/**
 * @since  1.6.5 [bbpress compatibility]
 */
if(function_exists('bbp_restore_all_filters')){ 
	bbp_restore_all_filters('the_content',0); 
}
?>
<!doctype html>
<html class="no-js" <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<?php wp_head(); ?>
	</head>
	<body id="proradio-body" <?php body_class(); ?>>
		<?php  
				
		/**
		 * ======================================================
		 * @var array
		 * Global classes to style di alternative design globals
		 * ======================================================
		 */
		$global_classes = [];

		
		$global_classes = implode( ' ', $global_classes );

		?>
		<div id="proradio-global" class="proradio-global <?php echo esc_attr( $global_classes ); ?>">
			
			<?php  
			
			/**
			 * ======================================================
			 * Load menu bar
			 * ======================================================
			 */
			get_template_part( 'template-parts/header/header' );

			?>

			<div id="proradio-ajax-master" class="proradio-master">
				<div id="proradio-pagecontent" class="proradio-pagecontent proradio-single proradio-single__fullwidth">
				<?php 
				if(function_exists('qtmplayer_interface')){
					qtmplayer_interface(); 
				}
				?>
				<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
					<div class="proradio-maincontent">
						<div class="proradio-entrycontent">
						<?php the_content(); ?>
						</div>
					</div>
				<?php endwhile; endif; ?>
				</div>
		<?php 
		 
get_footer();