<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.0
 */

// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

wp_reset_postdata();
global $post;



$items = array(
	array( 'release', esc_html__('Releases','proradio'), 'genre'),
	array( 'podcast', esc_html__('Podcast','proradio'), 'podcastfilter'),
	array( 'artist', esc_html__('Artists','proradio'), 'artistgenre'),
	array( 'event', esc_html__('Events','proradio'), 'eventtype'),
	array( 'chart', esc_html__('Charts','proradio'), 'chartcategory'),
	array( 'members', esc_html__('Members','proradio'), 'membertype'),
	array( 'radiochannel', esc_html__('Radios','proradio'), 'radio-genre'),
	array( 'schedule',  esc_html__("Schedule","proradio"), 'schedulefilter'),
	array( 'shows',  esc_html__("Shows","proradio"), 'genre')
);


$custom_tax_series = 'podcastfilter';
if( function_exists( 'proradio_series_custom_series_name' )){
	$custom_tax_series = proradio_series_custom_series_name();
}

?>
<div id="proradio-breadcrumb" class="proradio-breadcrumb">
	<ul class="proradio-breadcrumb__list" itemtype="http://schema.org/BreadcrumbList">
		<?php 
		
			?>
			<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><i class="material-icons">home</i><a itemtype="http://schema.org/ListItem" itemprop="item" href="<?php echo esc_url( home_url( '/' ) ); ?>"> <span itemprop="name"><?php esc_html_e('Home', 'proradio'); ?></span><meta content="1" itemprop="position"></a></li>
			<?php  
			if (is_category() ) {
				?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><i class="material-icons">keyboard_arrow_right</i><?php the_category('</li><li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><i class="material-icons">keyboard_arrow_right</i>'); ?><meta content="2" itemprop="position"></li>
				<?php
			}
			elseif (is_single()) {

				$id = $post->ID;

				if(get_post_type( $id ) == 'post'){
					$category = get_the_category(); 
					
					if( count($category) > 0 ){
						$category = get_the_category(); 
						$limit = 2;
						foreach($category as $i => $cat){
							if($limit > $i){	
								?><li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"> <i class="material-icons">keyboard_arrow_right</i><a itemtype="http://schema.org/Thing" itemprop="item" href="<?php echo get_category_link($cat->term_id ); ?>"> <span itemprop="name"><?php echo esc_html($cat->cat_name); ?></span></a></li><?php
							}
						}
					}
				}
				?>
				

				<?php
				// Only for podcasts in series
				if( get_post_format(  ) == 'audio'){
					?>
					<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><a itemtype="http://schema.org/Thing" itemprop="item" href="<?php echo get_post_format_link( 'audio' ); ?>"> <span itemprop="name"><?php esc_html_e("Podcasts", "proradio") ?></span></a></li>
					<?php
				}
				if( function_exists( 'proradio_series_custom_series_name' )){
					echo get_the_term_list( get_the_id(), $custom_tax_series, '<li itemprop="itemListElement" itemtype="http://schema.org/ListItem">'.'<i class="material-icons">keyboard_arrow_right</i> <span itemprop="name">', '</span></li><li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><i class="material-icons">keyboard_arrow_right</i>', '</li>' );
				}
			
				
				$postType = get_post_type_object(get_post_type($post->ID));
				if($postType){
					?>
					<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><a itemtype="http://schema.org/Thing" itemprop="item" href="<?php echo get_post_type_archive_link( $postType ); ?>"> <span itemprop="name"><?php echo esc_html( $postType->labels->name );?></span></a></li>
					<?php
				}


				?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><span itemprop="name"><?php the_title(); ?></span></li>
				<?php  
			} 
			elseif (is_page() && !is_home() && !is_front_page()) {
				?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><span itemprop="name"><?php the_title(); ?></span></li>
				<?php  
			} elseif ( is_tax( $custom_tax_series ) ) {
				$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); 
				?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><span itemprop="name"><?php echo esc_html( $term->name ); ?></span></li>
				<?php  			
			}
			elseif (is_tag()) {
				?><li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php single_tag_title(); ?></li></ul>
				<?php
			}
			elseif (is_day()) { ?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php esc_html_e('Archive for',"proradio"); the_time('F jS, Y'); ?></li>
				<?php
			}
			elseif (is_month()) { ?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php esc_html_e('Archive for',"proradio"); the_time('F, Y'); ?></li>
				<?php
			}
			elseif (is_year()) { ?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php esc_html_e('Archive for',"proradio"); the_time('Y'); ?></li>
				<?php
			}
			elseif (is_author()) { ?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php esc_html_e('Author archive',"proradio"); the_time('Y'); ?></li>
				<?php
			}
			elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {
				?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php esc_html_e('Blog archive',"proradio"); ?></li>
				<?php 
			}
			elseif (is_search()) {
				?>
				<li itemprop="itemListElement" itemtype="http://schema.org/ListItem"><meta content="2" itemprop="position"><i class="material-icons">keyboard_arrow_right</i><?php
				printf( 
					esc_html__( 'Search Results for: %s', "proradio" ), 
					esc_html(get_search_query())
				); 
				?></li><?php
			}
		
		?>
	</ul>
</div>

