<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.0
*/

// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/**
 * ======================================================
 * Thumbnails
 * ------------------------------------------------------
 * Change default thumbnails sizes 
 * ======================================================
 */
if (!function_exists( 'proradio_setup_options' )){
	add_action( 'after_switch_theme', 'proradio_setup_options' );
	function proradio_setup_options () {
		update_option( 'medium_size_w', 770 );
		update_option( 'medium_size_h', 770 );
		update_option( 'large_size_w', 1170 );
		update_option( 'large_size_h', 1170 );
	}
}


/**
 * ======================================================
 * Elementor setup
 * ======================================================
 */
if (!function_exists( 'proradio_setup_options' )){
	add_action( 'after_switch_theme', 'proradio_elementor_setup_options' );
	function proradio_elementor_setup_options () {
		$exp = [
			'elementor_experiment-e_optimized_assets_loading',
			'elementor_experiment-e_optimized_css_loading',
			'elementor_experiment-e_font_icon_svg',
			'elementor_experiment-additional_custom_breakpoints',
			'elementor_experiment-e_hidden_wordpress_widgets',
			'elementor_experiment-a11y_improvements',
			'elementor_experiment-admin-top-bar',
			'elementor_experiment-container'
		];
		foreach($exp as $e){
			update_option( $e, 'inavtive');
		}
	}
}
