<?php  

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


if(!function_exists('proradio_refetch_license_button')){
	function proradio_refetch_license_button( $link_text = 'Refresh' ){
		ob_start();
		$nonce_action_refetch = 'proradio-refetch-now';
		$nonce_name_refetch = 'proradio-refetch-code';
		$proradio_iid = proradio_iid();
		$ack = get_option( ( 'proradio_ack_'. $proradio_iid ) );
		$license = get_option( ( 'proradio_licensekey_'. $proradio_iid ) );
		?>
		<form action="<?php echo admin_url() . 'themes.php?page=proradio-welcome'; ?>" method="post">
			<?php wp_nonce_field( $nonce_action_refetch, $nonce_name_refetch, true, true ); ?>
			<?php wp_nonce_field( 'proradio_license_update_action', 'proradio_license_update_field' ); ?>
			<input type="hidden" name="proradio-refetch-license" id="proradio-refetch-license" value="refetch">
			<input type="hidden" name="proradiopcode" value="<?php echo esc_attr($license); ?>">
			<input type="submit" class="button button-primary" value="<?php echo esc_attr($link_text); ?>">
		</form>
		<?php  
		return ob_get_clean();

	}
}
/**
 * ===============================================
 * REMOVE THE ACTIVATION
 * ===============================================
 */
if(!function_exists('proradio_refetch_license_action')){
	function proradio_refetch_license_action( $link_text = 'Refresh' ){
		ob_start();
		/**
		 * ==========================================================
		 * Auto setup function
		 * ==========================================================
		 * */
		$nonce_action_refetch = 'proradio-refetch-now';
		$nonce_name_refetch = 'proradio-refetch-code';
		if ( ! empty( $_POST ) ) {
			if(isset($_POST["proradio-refetch-license"])){
				if( ! 'refetch' === $_POST["proradio-refetch-license"]){
					return ob_get_clean();
				}
				if(!check_admin_referer( $nonce_action_refetch, $nonce_name_refetch )){
					?>
					User verification expired.
					<?php
					return ob_get_clean();
				} else {
					$proradio_iid = proradio_iid();
					delete_option( 'proradio_ack_'. $proradio_iid );
					delete_option( 'proradio_licensekey_'. $proradio_iid );
					echo 'Code correctly refreshed';
				}
			}
		}
		return ob_get_clean();
	}
}