<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/**
 * =====================================================
 * Styling
 * =====================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'single_capt_0',
    'label'       => '',
    'section'     => 'single_post_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Blog and archives styling', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'archive_template',
	'label'       => esc_html__( 'Archives template', 'proradio' ),
	'description' => esc_html__( 'Set default tempalte for blog archives', "proradio" ),
	'section'     => 'single_post_section',
	'default'     => 'archive-sidebar',
	'multiple'    => false,
	'choices'     => array(
			'archive-sidebar' 	=> esc_attr__( 'Default: archive sidebar', 'proradio' ),
			'archive-no-sidebar' 	=> esc_attr__( 'Archive no sidebar', 'proradio' ),
			'archive-grid-sidebar' 	=> esc_attr__( 'Grid sidebar', 'proradio' ),
			'archive-grid' 	=> esc_attr__( 'Grid no sidebar', 'proradio' ),
			'archive-horizontal' 	=> esc_attr__( 'Horizontal sidebar', 'proradio' ),
			'archive-masonry' 	=> esc_attr__( 'Masonry', 'proradio' ),
		)
) );







/**
 * =====================================================
 * Styling
 * =====================================================
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'single_capt_1',
    'label'       => '',
    'section'     => 'single_post_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Design', "proradio" ).'</h2>',
) );

/**
 * Blog post sidebar
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_postsidebar',
	'label'       => esc_html__( 'Blog post sidebar', "proradio" ),
	'section'     => 'single_post_section',
	'description' => esc_html__( 'Enable sidebar in single posts. Does not affect other post types.', "proradio" ),
));




/* = Events settings
=============================================*/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'single_previous',
	'label'       => esc_html__( 'Display previous post', "proradio" ),
	'section'     => 'single_post_section',
	'default'		=> '1',
	'description' => esc_html__( 'In single post article, display the previous post', "proradio" ),
	'priority'    => 10,
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'post_dates',
	'label'       => esc_html__( 'Post date visibility', "proradio" ),
	'section'     => 'single_post_section',
	'description' => esc_html__( 'Make the post date visible in frontend or hide it globally, for archive items and single posts', "proradio" ),
	'priority'    => 10,
	'transport'   => 'refresh',
	'multiple'    => false,
	'choices'     => array(
			'' 	=> esc_attr__( 'Yes', 'proradio' ),
			'none'   	=> esc_attr__( 'No', 'proradio' ),
			
		),
	'output'    => array(
		array(
			'element'       => '.proradio-date',
			'property'      => 'display',
			'suffix'      => ' !important',
		),
	),
));



/**
 * Blog post ajax comment form submit
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'ajax_comments',
	'label'       => esc_html__( 'Ajax comments form', "proradio" ),
	'section'     => 'single_post_section',
	'description' => esc_html__( 'Submit comments without reloading the page', "proradio" ),
));


