<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$selector_element = '.proradio-post__ver ';
$section = 'card_vertical';

/**
 * ===========================================================================
 * Mobile
 * =========================================================================== 
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'card_vertical_sep_caption_header1',
    'label'       => '',
    'section'     => $section,
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Mobile', "proradio" ).'</h2>',
) );


Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'post__ver-pad-content-s',
	'label'       => esc_html__( 'Vertical cards padding', 'proradio' ).' '.esc_html__( 'mobile', 'proradio' ),
	'description' => esc_html__( 'Change the content padding for the item cards used in post and pages grids.', "proradio" ),
	'section'     => $section,
	'default'     => [
		'padding-top'    => '5%',
		'padding-bottom' => '5%',
		'padding-left'   => '5%',
		'padding-right'  => '5%',
	],
	'transport'   => 'auto',
	'output'    => array(
		array(
			 'choice'      => 'padding-top',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-top',
			'media_query' => '@media (max-width: 600px)'
		),	
		array(
			 'choice'      => 'padding-bottom',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-bottom',
			'media_query' => '@media (max-width: 600px)'
		),
		array(
			 'choice'      => 'padding-left',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-left',
			'media_query' => '@media (max-width: 600px)'
		),
		array(
			 'choice'      => 'padding-right',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-right',
			'media_query' => '@media (max-width: 600px)'
		),	
	),
] );







/**
 * ===========================================================================
 * Tablet
 * =========================================================================== 
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'card_vertical_sep_caption_header2',
    'label'       => '',
    'section'     => $section,
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Tablet', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'post__ver-pad-content-m',
	'label'       => esc_html__( 'Vertical cards padding', 'proradio' ).' '.esc_html__( 'tablet', 'proradio' ),
	'section'     => $section,
	'default'     => [
		'padding-top'    => '5.5%',
		'padding-bottom' => '5.5%',
		'padding-left'   => '5.5%',
		'padding-right'  => '5.5%',
	],
	'transport'   => 'auto',
	'output'    => array(
		array(
			 'choice'      => 'padding-top',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-top',
			'media_query' => '@media (min-width: 601px)'
		),	
		array(
			 'choice'      => 'padding-bottom',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-bottom',
			'media_query' => '@media (min-width: 601px)'
		),

		array(
			 'choice'      => 'padding-left',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-left',
			'media_query' => '@media (min-width: 601px)'
		),

		array(
			 'choice'      => 'padding-right',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-right',
			'media_query' => '@media (min-width: 601px)'
		),	
	),
] );



/**
 * ===========================================================================
 * Desktop
 * =========================================================================== 
 * */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'card_vertical_sep_caption_header3',
    'label'       => '',
    'section'     => $section,
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Desktop', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'post__ver-pad-content-l',
	'label'       => esc_html__( 'Vertical cards padding', 'proradio' ).' '.esc_html__( 'desktop', 'proradio' ),
	'section'     => $section,
	'default'     => [
		'padding-top'    => '28px',
		'padding-bottom' => '28px',
		'padding-left'   => '28px',
		'padding-right'  => '28px',
	],
	'transport'   => 'auto',
	'output'    => array(
		array(
			 'choice'      => 'padding-top',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-top',
			'media_query' => '@media (min-width: 1200px)'
		),	
		array(
			 'choice'      => 'padding-bottom',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-bottom',
			'media_query' => '@media (min-width: 1200px)'
		),

		array(
			 'choice'      => 'padding-left',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-left',
			'media_query' => '@media (min-width: 1200px)'
		),

		array(
			 'choice'      => 'padding-right',
			'element'       => $selector_element.' .proradio-post__content',
			'property'      => 'padding-right',
			'media_query' => '@media (min-width: 1200px)'
		),	
	),
] );