<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
$section = "proradio_menu_design_section";



/**
 * ======================================================
 *  Font size
 * ======================================================
 */



Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header_menudesign_1',
    'label'       => '',
    'section'     =>$section,
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Styling', "proradio" ).'</h2>',
    // 'priority'    => 10,
) );

Kirki::add_field( 'proradio_config', array(
    'type'        => 'typography',
    'settings'    => 'proradio_typography_menu_spec',
    'label'       => esc_html__( 'Menu font', "proradio" ),
    'section'     =>$section,
    'default'     => array(
        'font-family'    => 'Montserrat',
        'variant'        => '600',
        'letter-spacing' => '0.04em',
        'subsets'        => array( 'latin-ext' ),
        'text-transform' => 'uppercase',
    ),
    'description' => esc_html__('Default: Montserrat 600. Be sure your language is supported by the font you choose on fonts.google.com', 'proradio'),
    // 'priority'    => 10,
    'output'      => array(
        array(
            'element' => '#proradio-global #proradio-headerbar #proradio-menubar.proradio-menubar, #proradio-global .proradio-menubar, .proradio-secondaryhead,  .proradio-menu-tree ',
            'property' => 'font-family',
        ),
        array(
            'element' => '#proradio-headerbar #proradio-menubar li  a,  #proradio-headerbar .proradio-menubar__secondary li a',
            'property' => 'font-family',
        ),
    ),
));


Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'menu_size',
    'label'       => esc_html__( 'Menu font size', 'proradio' ),
    'section'     => $section,
    'default'     => 12,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 12,
        'max'  => 22,
        'step' => 1,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal li a, .proradio-menu-horizontal .proradio-menubar > li ul li a',
            'property'      => 'font-size',
            'value_pattern' => esc_attr( ' $px' ),
            'media_query' => '@media (min-width: 1200px)'
        ),
    ),
] );



Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'main_menu_height',
    'label'       => esc_html__( 'Main menu height', 'proradio' ),
     'section'     => $section,
    'default'     => 42,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 10,
        'max'  => 120,
        'step' => 1,
    ],
    'output'    => array(
        array(
            'element'       => '#proradio-menubar',
            'property'      => 'min-height',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),
        array(
            'element'       => '#proradio-menubar > li > a',
            'property'      => 'line-height',
            'value_pattern' => esc_attr( ' $px;' ),
            'media_query' => '@media (min-width: 1200px)'
        ),


    ),
] );
Kirki::add_field( 'proradio_config', [
    'type'        => 'dimensions',
    'settings'    => 'menu_items_padding',
    'label'       => esc_html__( 'Main menu items padding', 'proradio' ),
     'section'     => $section,
    'default'     => [
        'padding-top'    => '0px',
        'padding-bottom' => '0px',
        'padding-left'   => '5px',
        'padding-right'  => '5px',
    ],
    'transport'   => 'auto',
    'output'    => array(
        array(
             'choice'      => 'padding-top',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a',
            'property'      => 'padding-top',
            'media_query' => '@media (min-width: 1200px)'
        ),  
        array(
             'choice'      => 'padding-bottom',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a',
            'property'      => 'padding-bottom',
            'media_query' => '@media (min-width: 1200px)'
        ),

        array(
             'choice'      => 'padding-left',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a',
            'property'      => 'padding-left',
            'media_query' => '@media (min-width: 1200px)'
        ),

        array(
             'choice'      => 'padding-right',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a, .proradio-menu-horizontal .proradio-menubar>li.menu-item-has-children a',
            'property'      => 'padding-right',
            'media_query' => '@media (min-width: 1200px)'
        ),  
    ),
] );
Kirki::add_field( 'proradio_config', [
    'type'        => 'dimensions',
    'settings'    => 'menu_items_padding',
    'label'       => esc_html__( 'Main menu items padding', 'proradio' ),
     'section'     => $section,
    'default'     => [
        'padding-top'    => '0px',
        'padding-bottom' => '0px',
        'padding-left'   => '12px',
        'padding-right'  => '12px',
    ],
    'transport'   => 'auto',
    'output'    => array(
        array(
             'choice'      => 'padding-top',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a',
            'property'      => 'padding-top',
            'media_query' => '@media (min-width: 1200px)'
        ),  
        array(
             'choice'      => 'padding-bottom',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a',
            'property'      => 'padding-bottom',
            'media_query' => '@media (min-width: 1200px)'
        ),

        array(
             'choice'      => 'padding-left',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a',
            'property'      => 'padding-left',
            'media_query' => '@media (min-width: 1200px)'
        ),

        array(
             'choice'      => 'padding-right',
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li a, .proradio-menu-horizontal .proradio-menubar>li.menu-item-has-children a',
            'property'      => 'padding-right',
            'media_query' => '@media (min-width: 1200px)'
        ),  
    ),
] );

Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'menu_items_space',
    'label'       => esc_html__( 'Items spacing', 'proradio' ),
     'section'     => $section,
    'default'     => 0,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 0,
        'max'  => 100,
        'step' => 1,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar > li',
            'property'      => 'padding',
            'value_pattern' => esc_attr( '0 $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),

    ),
] );




Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'submenu_offset',
    'label'       => esc_html__( 'Sub menu offset', 'proradio' ),
    'description' => esc_html__( 'Change the vertical spacing of the submenu container in desktop', 'proradio' ),
    'section'     => $section,
    'default'     => 20,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 0,
        'max'  => 100,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar > li ul',
            'property'      => 'padding-top',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),      
    ),
] );


Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header_menudesign_2',
    'label'       => '',
    'section'     =>$section,
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Submenu icon style', "proradio" ).'</h2>',
    // 'priority'    => 10,
) );

Kirki::add_field( 'proradio_config', array(
    'type'        => 'select',
    'settings'    => 'menu-parent-icon',
    'label'       => esc_html__( 'Submenu icon', 'proradio' ),
    'description' => esc_html__( 'Change the icon to indicate a submenu', "proradio" ),
     'section'     => $section,
    'multiple'    => false,
    'transport'   => 'auto',
    'choices'     => array(
            '"\e145"'   => esc_attr__( 'Default', 'proradio' ),
            '"\e313"'   => esc_attr__( 'Arrow down', 'proradio' ).' V1',
            '"\e5c5"'   => esc_attr__( 'Arrow down', 'proradio' ).' V2',
            '"\e5db"'     => esc_attr__( 'Arrow down', 'proradio' ).' V3',
            '"\e315"' => esc_attr__( 'Arrow right', 'proradio' ).' V1',
            '"\e8e4"' => esc_attr__( 'Arrow right', 'proradio' ).' V2',
            '"\e5c8"' => esc_attr__( 'Arrow right', 'proradio' ).' V3',
          
        ),
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children::after',
            'property'      => 'content',
            // 'value_pattern' => esc_attr( " '\$' ;" ),
            'media_query' => '@media (min-width: 1200px)'
        ),      
    ),
) );


/*

Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'icon_siz',
    'label'       => esc_html__( 'Icon size', 'proradio' ),
     'section'     => $section,
    'default'     => 16,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 0,
        'max'  => 24,
        'step' => 1,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children::after',
            'property'      => 'font-size',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),
         array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children::after',
            'property'      => 'width',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),
          array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children::after',
            'property'      => 'height',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),

    ),
] );

*/


Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'icon_pos',
    'label'       => esc_html__( 'Icon position right', 'proradio' ),
     'section'     => $section,
    'default'     => 0,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 0,
        'max'  => 50,
        'step' => 1,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children::after',
            'property'      => 'right',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),

    ),
] );


Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'icon_space',
    'label'       => esc_html__( 'Icon spacing', 'proradio' ),
     'section'     => $section,
    'default'     => 16,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 12,
        'max'  => 30,
        'step' => 1,
    ],
    'output'    => array(
  
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar>li.menu-item-has-children a',
            'property'      => 'padding-right',
            'value_pattern' => esc_attr( ' $px; ' ),
            'media_query' => '@media (min-width: 1201px)'
        ),  

    ),
] );


Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'icon_pos_t',
    'label'       => esc_html__( 'Icon position top', 'proradio' ),
     'section'     => $section,
    'default'     => 46,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => 0,
        'max'  => 100,
        'step' => 1,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children::after',
            'property'      => 'top',
            'value_pattern' => esc_attr( ' $%; ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),

    ),
] );

Kirki::add_field( 'proradio_config', [
    'type'        => 'slider',
    'settings'    => 'icon_rot',
    'label'       => esc_html__( 'Icon rotation', 'proradio' ),
     'section'     => $section,
    'default'     => -45,
    'transport'   => 'auto',
    'choices'     => [
        'min'  => -360,
        'max'  => 360,
        'step' => 5,
    ],
    'output'    => array(
        array(
            'element'       => '.proradio-menu-horizontal .proradio-menubar .menu-item-has-children:hover::after',
            'property'      => 'transform',
            'value_pattern' => esc_attr( 'rotate( $deg); ' ),
            'media_query' => '@media (min-width: 1200px)'
        ),

    ),
] );





Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header_menudesign_3',
    'label'       => '',
    'section'     =>$section,
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Hover effect', "proradio" ).'</h2>',
) );


Kirki::add_field( 'proradio_config', array(
    'type'        => 'select',
    'settings'    => 'menu_hover_fx',
    'label'       => esc_html__( 'Hover effect', 'proradio' ),
     'section'     => $section,
    'multiple'    => false,
    'default'    => 'proradio-menustyle-default',
    'transport'   => 'refresh',
    'choices'     => array(
            'proradio-menustyle-default'   => esc_attr__( 'Default', 'proradio' ),
            'proradio-menustyle-classic'   => esc_attr__( 'Classic', 'proradio' ),
            'proradio-menustyle-one'   => esc_attr__( 'Alternative', 'proradio' ),
             
          
        )
) );
