<?php  

// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}



Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_caption_header_btns',
    'label'       => '',
    'section'     => 'proradio_menu_buttons',
    'default'     => '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Menu buttons', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'show_social_mainbar',
	'label'       => esc_html__( 'Display social in main menu bar', "proradio" ),
	'description' => esc_html__( 'Display the social icons in the main menu bar. Social icons can be set in the customizer "Social links" section.', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'default'       => 0,
));


if ( function_exists('WC') ){
	Kirki::add_field( 'proradio_config', array(
		'type'        => 'toggle',
		'settings'    => 'proradio_wc_cart',
		'label'       => esc_html__( 'Display shopping cart for WooCommerce', "proradio" ),
		'section'     => 'proradio_menu_buttons',
		'description' => esc_html__( 'If using WooCommerce, will add the cart icon and total to the header.', "proradio" ),
		// 'priority'    => 10,
		'default'     => '0'
	));
}

Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'proradio_play_header',
	'label'       => esc_html__( 'Play button', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'description' => esc_html__( 'Add a play/pause switch to the header', "proradio" ),
	// 'priority'    => 10,
	'default'     => '0'
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'text',
	'settings'    => 'proradio_play_label',
	'label'       => esc_html__( 'Play button text', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	// 'priority'    => 10,
	'active_callback' => [
		[
			'setting'  => 'proradio_play_header',
			'operator' => '==',
			'value'    => true,
		]
	],
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'proradio_vol_header',
	'label'       => esc_html__( 'Volume control', "proradio" ),
	'description' => esc_html__( 'Display the volume in the menu, will not appear in the player bar.', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'description' => esc_html__( 'Desktop only.', "proradio" ),
	// 'priority'    => 10,
	'default'     => '0'
));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'proradio_search_header',
	'label'       => esc_html__( 'Display search', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'description' => esc_html__( 'Add the search icon to the header bar', "proradio" ),
	// 'priority'    => 10,
	'default'     => '0'
));

/**
 * Menu buttons color
 **/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'menu_btn_bg',
	'label'       => esc_html__( 'Buttons background', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '#proradio-menu .proradio-menubtns__c .proradio-btn.proradio-btn__r',
			'property'      => 'background',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'menu_btn_bgh',
	'label'       => esc_html__( 'Buttons background', "proradio" ).' '.esc_html__( 'hover', 'proradio' ),
	'section'     => 'proradio_menu_buttons',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '#proradio-menu .proradio-menubtns__c .proradio-btn.proradio-btn__r:hover',
			'property'      => 'background',
		),
	),
));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'menu_btn_border',
	'label'       => esc_html__( 'Buttons border', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'choices'     => [
		'alpha' => true,
	],
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '#proradio-menu .proradio-menubtns__c .proradio-btn.proradio-btn__r',
			'property'      => 'border-color',
		),
	),
));

// Menu colors
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'menu_btn_icon',
	'label'       => esc_html__( 'Buttons icon', "proradio" ),
	'section'     => 'proradio_menu_buttons',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '#proradio-menu .proradio-menubtns__c .proradio-btn.proradio-btn__r i',
			'property'      => 'color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'menu_btn_icon_h',
	'label'       => esc_html__( 'Buttons icon', "proradio" ).' '.esc_html__( 'hover', 'proradio' ),
	'section'     => 'proradio_menu_buttons',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '#proradio-menu .proradio-menubtns__c .proradio-btn.proradio-btn__r:hover i',
			'property'      => 'color',
		),
	),
));



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'menu_btn_iconsize',
	'label'       => esc_html__( 'Menu button icons size', 'proradio' ),
	'section'     => 'proradio_menu_buttons',
	'default'		=> 20,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 10,
		'max'  => 40,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '#proradio-menu .proradio-menubtns__c .proradio-btn i',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),
] );
