<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/* = Call to action section
=============================================*/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'breadcrumb_on',
	'label'       => esc_html__( 'Enable breadcrumb navigation', "proradio" ),
	'section'     => 'proradio_breadcrumb_section',
	'priority'    => 10,
));


Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'breadcrumb_padding',
	'label'       => esc_html__( 'Padding', 'proradio' ),
	'section'     => 'proradio_breadcrumb_section',
	'default'     => 0,
	'transport'   => 'auto',
	'default'     => [
		'padding-top'    => '0px',
		'padding-bottom' => '0px',
		'padding-left'   => '0px',
		'padding-right'  => '0px',
	],
	'output'      => array(
		array(
		  'choice'      => 'padding-top',
		  'element'     => '.proradio-breadcrumb > ul',
		  'property'    => 'padding-top',
		),
		array(
		  'choice'      => 'padding-bottom',
		  'element'     => '.proradio-breadcrumb > ul',
		  'property'    => 'padding-bottom',
		),
		array(
		  'choice'      => 'padding-left',
		  'element'     => '.proradio-breadcrumb > ul',
		  'property'    => 'padding-left',
		),
		array(
		  'choice'      => 'padding-right',
		  'element'     => '.proradio-breadcrumb > ul',
		  'property'    => 'padding-right',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'breadcrumb_on',
			'operator'  => '==',
			'value'     => true,
		]
	],

] );




// Template
Kirki::add_field( 'proradio_config', array(
	'type'      => 'select',
	'settings'  => 'breadcrumb_aligh',
	'label'     => esc_html__( 'Alignment', 'proradio' ),
	'section'   => 'proradio_breadcrumb_section',
	'multiple'    => false,
	'default'	=> 'default',
	'choices'   => array(
		''   => esc_attr__( 'Default', 'proradio' ),
		'flex-start' 	=> esc_attr__( 'Left', 'proradio' ), // double is part of the css class, do not change
		'flex-end' 	=> esc_attr__( 'Right', 'proradio' ), // double is part of the css class, do not change
		'center' 	=> esc_attr__( 'Center', 'proradio' ), // double is part of the css class, do not change
	),
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-breadcrumb > ul',
			'property'      => 'justify-content',
			'media_query' => '@media (min-width: 1200px)'
		),
	),
	'active_callback' => [
		[
			'setting'   => 'breadcrumb_on',
			'operator'  => '==',
			'value'     => true,
		]
	],
));



Kirki::add_field( 'proradio_config', array(
	'type'        => 'typography',
	'settings'    => 'breadcrumb_font',
	'label'       => esc_html__( 'Menu font', "proradio" ),
	'section'     => 'proradio_breadcrumb_section',
	'default'     => array(
		'font-family'    => 'Montserrat',
		'variant'        => '600',
		'letter-spacing' => '0.04em',
		'subsets'        => array( 'latin-ext' ),
		'text-transform' => 'uppercase',
	),
	'description' => esc_html__('Default: Montserrat 600. Be sure your language is supported by the font you choose on fonts.google.com', 'proradio'),
	// 'priority'    => 10,
	'output'      => array(
		array(
			'element' => '.proradio-breadcrumb > ul > li > a, .proradio-breadcrumb > ul > li > span',
			'property' => 'font-family'
		),
	),
	'active_callback' => [
		[
			'setting'   => 'breadcrumb_on',
			'operator'  => '==',
			'value'     => true,
		]
	],
));


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'breadcrumb_fontsize',
	'label'       => esc_html__( 'Font size', 'proradio' ),
	'section'     => 'proradio_breadcrumb_section',
	'default'     => 13,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 10,
		'max'  => 16,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-breadcrumb > ul > li *, .proradio-breadcrumb > ul > li i.material-icons',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
		),
	),
	'active_callback' => [
		[
			'setting'   => 'breadcrumb_on',
			'operator'  => '==',
			'value'     => true,
		]
	],
] );





Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'breadcrumb_background',
	'label'       => esc_html__( 'Background', "proradio" ),
	'section'     => 'proradio_breadcrumb_section',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-breadcrumb',
			'property'      => 'background-color',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'breadcrumb_on',
			'operator'  => '==',
			'value'     => true,
		]
	],
));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'breadcrumb_color',
	'label'       => esc_html__( 'Color', "proradio" ),
	'section'     => 'proradio_breadcrumb_section',
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => '.proradio-breadcrumb',
			'property'      => 'color',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'breadcrumb_on',
			'operator'  => '==',
			'value'     => true,
		]
	],
));
