<?php  
/**
 * @package  WordPress
 * @subpackage qtmplayer
 * ===============================================================
 * 
 * Ajax music stats from Qantum Themes SL
 * All rights reserved. This software can only be used within 
 * a Qantum Themes product.
 * 
 * ===============================================================
 * */

if(!function_exists('qtmplayer_ajax_stats')){

	add_action('wp_ajax_nopriv_qtmplayer-ajax-hit', 'qtmplayer_ajax_hit');
	add_action('wp_ajax_qtmplayer-ajax-hit', 'qtmplayer_ajax_hit');

	function qtmplayer_ajax_hit(){
		$response = [
			"errors" => 0
		];
		if(!isset( $_POST['post_id'] ) || !isset($_POST['nonce']) ){
			$response['errors'] = 'Illegal action.';
			wp_die();
		}
		if ( ! wp_verify_nonce( $_POST['nonce'], 'ajax-stats' ) ){
			$response['errors'] = 'Illegal token.';
			wp_die();
		}

		
		$post_meta_name = qtmplayer_stats_meta_name();
		$post_id = intval( trim( $_POST['post_id'] ) );
		$post_meta = get_post_meta($post_id, $post_meta_name, true);
		$today = date('Y-m-d');


		// Cookie to couont unique users interactions
		
		$arr_cookie_options = array (
            'expires' => time() + 60*60*24, // 1 day
            'path' => '/',
        );
        $cookiearray_name = 'qtmplayerPlayed';
		$store_unique_click = true;
		if( isset( $_COOKIE['qtmplayerPlayed'] ) ){
			if( array_key_exists( $post_id, $_COOKIE['qtmplayerPlayed'] ) ){
				$store_unique_click = false;
			}
		}

		// We have to count this click in the unique counter
		if( $store_unique_click ){
			$cookie_played_array[] = $post_id;
			setcookie('qtmplayerPlayed['.$post_id.']', date('YmdHis'), $arr_cookie_options); 
			$response['created_cookie'] = $post_id;
		}



		// Debug output
		$response['count_unique_click'] = $store_unique_click;
		

		/**
		 * =======================================
		 * Add counter to existing stats
		 * OR
		 * Create new
		 * =======================================
		 * */
		if($post_meta){
			$hits = array_unique( maybe_unserialize( $post_meta ), SORT_REGULAR );
			if(array_key_exists( $today , $hits)){
				
				// Unique hits

				if(array_key_exists('U', $hits[$today])){
					if( $store_unique_click ){
						$hits[$today]['U'] = $hits[$today]['U'] + 1;
					}
				} else {
					if( $store_unique_click ){
						$hits[$today]['U'] = 1;
					}
				}

				// Total hits
				if(array_key_exists('T', $hits[$today])){
					$hits[$today]['T'] = $hits[$today]['T'] + 1;
				} else {
					$hits[$today]['T'] = 1;
				}

			} else {
				$hits[$today] = [
					'T' => 1,
					'U' => 1,
				];
			}
		} else {
			$hits = [];
			$hits[$today] = [
				'T' => 1,
				'U' => 1,
			];
		}

		$response['hits'] = $hits;
		
		if( ! update_post_meta( $post_id, $post_meta_name,  maybe_serialize( $hits ) ) ){
			$errors[] = 'Error updating stats meta';
			$response['result'] = 'fail';
		} else {
			$response['result'] = 'success';
		}

		if( !empty($errors) ){
			$response['errors'] = $errors;
		}
		echo json_encode($response);
		wp_die();

	}
}




/**
 * 
 * ===================================================================
 * Create demo stats for a campaign
 * ===================================================================
 * 
 */

add_action("init", function(){
	if(is_user_logged_in()){
		if(isset($_GET)){
			if(array_key_exists('qtmplayer-stats-create-demodata', $_GET)){
				if( $_GET['qtmplayer-stats-create-demodata'] !== null && $_GET['qtmplayer-stats-create-demodata'] !== ''){
					$user = wp_get_current_user();
					$allowed_roles = array( 'administrator' );
					
					if( array_intersect($allowed_roles, $user->roles ) ) {
						$post_id =  $_GET['qtmplayer-stats-create-demodata'];

						$today = date('Y-m-d');
						$stats = [];
						echo 'Create demo stats data for post: '.get_the_title( $post_id );;
						$days = 120;
						for( $n = 1; $n <= $days; $n++){
							$date = date('Y-m-d', strtotime($today. ' - '.( $days - $n ).' days')); 
							$random = random_int(50,200);

							$stats[$date] = [
								'T' => $random,
								'U' => round( $random / random_int(2,3) ),
							];
						}


						$post_meta_name = qtmplayer_stats_meta_name();
						$post_id = intval( trim( $post_id ) );
						$post_meta = get_post_meta($post_id, $post_meta_name, true);
						// echo  $post_meta;

						// $hits = array_unique( maybe_unserialize( $post_meta ), SORT_REGULAR );
						// echo '<h2>Old data</h2>';
						// echo '<pre>';
						// print_r($hits);
						// echo '</pre>';

						// echo '<h2>New data</h2>';
						// echo '<pre>';
						// print_r($stats);
						// echo '</pre>';
						if( update_post_meta( $post_id, $post_meta_name, serialize($stats) ) ){

						}
						wp_die('Random stats generated correctly. <a target="_blank" href="'.get_the_permalink( $post_id ).'">View post</a>');
					}
				}
			}
		}
	}
});
