<?php  
/**
 * Plugin Name: Pro.Radio Music Player
 * Description: Music player
 * Plugin URI: http://pro.radio
 * Author URI: http://pro.radio
 * Author: Pro.Radio - Qantum Themes SL
 * Version: PR.6.2.1
 * Text Domain: qtmplayer
 * Domain Path: /languages
*/

/**
 * @package  WordPress
 * @subpackage qtmplayer
 */


/**
 * =================================================================================
 * Constants
 * =================================================================================
 */
define( 'QTMPLAYER__VERSION', '6.2.1' );
define( 'QTMPLAYER__FILE__', __FILE__ );
define( 'QTMPLAYER_PLUGIN_BASE', plugin_basename( QTMPLAYER__FILE__ ) );
define( 'QTMPLAYER_PATH', plugin_dir_path( QTMPLAYER__FILE__ ) );
define( 'QTMPLAYER_URL', plugin_dir_url( QTMPLAYER__FILE__ ));



/**
 *
 *	The plugin textdomain
 * 
 */
if(!function_exists('qtmplayer_td')){
function qtmplayer_td() {
	load_plugin_textdomain( 'qtmplayer', FALSE, basename( dirname( __FILE__ ) ) . '/languages' );
}}
add_action( 'plugins_loaded', 'qtmplayer_td' );

/**
* Returns current plugin version.
* @return string Plugin version. Needs to stay here because of plugin file path
*/
if(!function_exists('qtmplayer_get_version')){
function qtmplayer_get_version() {
	return QTMPLAYER__VERSION;
}}

/**
* Returns current plugin version.
* @return string Plugin version. Needs to stay here because of plugin file path
*/
if(!function_exists('qtmplayer_plugin_dir_path')){
	function qtmplayer_plugin_dir_path() {
		return plugin_dir_path( __FILE__ );
	}
}

/**
* Flash URL
* @return string Plugin version. Needs to stay here because of plugin file path
*/
if(!function_exists('qtmplayer_flashurl')){
function qtmplayer_flashurl() {
	return plugins_url( '/assets/soundmanager/swf/' , __FILE__ );
}}



/**
 *  Check if current user can access stats
 * 	=============================================
 */
if(!function_exists('qtmplayer_user_can_view_stats')){
	function qtmplayer_user_can_view_stats (){
		if( get_option( 'qtmplayer_stats_public' ) ){
			return true;
		}
		if(is_user_logged_in()){
			// Is the author 
			if(  get_the_author_meta('ID') == get_current_user_id()  ) {
				return true;
			}
			// Or is admin
			$user = wp_get_current_user();
			$allowed_roles = array( 'administrator' );
			if( array_intersect($allowed_roles, $user->roles ) ){
				return true;
			}
			return false;
		}
	}
}


/**
 *  Check if current user can access stats
 * 	=============================================
 */
if(!function_exists('qtmplayer_stats_meta_name')){
	function qtmplayer_stats_meta_name (){
		return 'qtmplayer-stats';
	}
}


/**
 * 	Enqueue scripts
 * 	=============================================
 */
if(!function_exists('qtmplayer_scripts')){
function qtmplayer_scripts(){
	
	$ver = qtmplayer_get_version();
	wp_enqueue_style( "qtmplayer-socicon",plugins_url('/assets/css/qtmplayer.css'	, __FILE__ ), false, $ver, "all" );


	// Scripts =====================================================
	$deps = array('jquery','jquery-migrate',  'proradio-main');
	wp_enqueue_script( 'jquery-marquee', plugins_url('/assets/components/jquery.marquee-min.js' , __FILE__ ), $deps, $ver, true );  $deps[] = 'jquery-marquee';
	// Waveform
	wp_register_script( 'qtmplayer-waveform', plugins_url('/assets/js/qtmplayer-waveform.js' , __FILE__ ), $deps, $ver, true );
	wp_localize_script('qtmplayer-waveform', 'qtmplayer_ajax_var', array(
			'url' => admin_url('admin-ajax.php'),
			'peaksnonce' => wp_create_nonce('qtmplayer-ajax-nonce')
	));
	wp_enqueue_script('qtmplayer-waveform');  $deps[] = 'qtmplayer-waveform';

	// Stats
	if( get_option('qtmplayer_stats_enabled') ){
		wp_register_script( 'qtmplayer-stats', plugins_url('/stats/stats-ajax-min.js' , __FILE__ ), $deps, $ver, true );
		wp_localize_script('qtmplayer-stats', 'qtmplayer_stats_ajax_var', array(
				'track_click_once' => get_option('qtmplayer_stats_track_once'),
				'url' => admin_url('admin-ajax.php'),
				'statsnonce' => wp_create_nonce('ajax-stats')
		));
		wp_enqueue_script('qtmplayer-stats');  $deps[] = 'qtmplayer-stats';
		// View stats required library
		if( is_user_logged_in() || get_option( 'qtmplayer_stats_public' ) ){
			wp_enqueue_script('chart-js',  plugins_url( '/stats/chart.min.js', __FILE__ ),  array ('jquery'), '3.7.1', true);
		}
	}

	// Scripts
	if('1' === get_option( 'qtmplayer_min' )){
		wp_enqueue_script( 'qtmplayer', plugins_url('/assets/js/qtmplayer-min.js' , __FILE__ ), $deps, $ver, true ); $deps[] = 'qtmplayer';	
	} else {
		wp_enqueue_script( 'raphael', plugins_url('/assets/components/raphael/raphael.min.js' , __FILE__ ), $deps, $ver, true ); $deps[] = 'raphael';
		wp_enqueue_script( 'soundmanager2', plugins_url('/assets/soundmanager/script/soundmanager2-nodebug-jsmin.js'	, __FILE__ ), $deps, $ver, true ); $deps[] = 'soundmanager2';
		wp_enqueue_script( 'qtmplayer-smpo', plugins_url('/assets/js/qtmplayer-smpo.js'	, __FILE__ ), $deps, $ver, true ); $deps[] = 'qtmplayer-smpo';
		// wp_enqueue_script( 'qtmplayer-webapiplayer', plugins_url('/assets/js/qtmplayer-webapiplayer.js'	, __FILE__ ), $deps, $ver, true ); $deps[] = 'qtmplayer-webapiplayer';
		wp_enqueue_script( 'qtmplayer-radiofeed', plugins_url('/assets/js/qtmplayer-radiofeed.js' , __FILE__ ), $deps, $ver, true ); $deps[] = 'qtmplayer-radiofeed';	
		wp_enqueue_script( 'qtmplayer', plugins_url('/assets/js/qtmplayer.js' , __FILE__ ), $deps, $ver, true ); $deps[] = 'qtmplayer';	
	}
}}
add_action("wp_enqueue_scripts",'qtmplayer_scripts');



/**
 * 	Functions
 * 	=============================================
 */
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-volume-control.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-mp3streamtitle.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-playlist-open.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-playlist-close.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-create-track-array.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-create-track-data.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-create-track.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-create-singletrack.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-replace-audio.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-replace-audio-block.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-create-dllink.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-downloadlink.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-play-circle.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-play-button.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-play-button-text.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-isinpopup.php'); // since 3.3.3
include ( plugin_dir_path( __FILE__ ) . 'inc/func/qtmplayer-get-audio-source.php'); // since 3.3.3

// Interface
include ( plugin_dir_path( __FILE__ ) . 'inc/qtmplayer-interface.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/qtmplayer-json.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/qtmplayer-customizations.php');
include ( plugin_dir_path( __FILE__ ) . 'inc/qtmplayer-cache-spectrum.php');

// Custon fields
include ( plugin_dir_path( __FILE__ ) . 'inc/qtmplayer-customfields.php');


// Templates functions
include ( plugin_dir_path( __FILE__ ) . 'templates/add-to-playlist.php');
include ( plugin_dir_path( __FILE__ ) . 'templates/qtmplayer-tracklist.php');


// Admin interface
include ( plugin_dir_path( __FILE__ ) . 'inc/admin/qtmplayer-admin.php');

// Statistics ajax
include ( plugin_dir_path( __FILE__ ) . 'stats/stats-ajax.php');
include ( plugin_dir_path( __FILE__ ) . 'stats/frontend-stats.php');

/**
 * 	customizer
 * 	=============================================
 */
if ( function_exists( 'Kirki' ) ) {
	require_once	plugin_dir_path( __FILE__ ) . '/customizer/kirki-config-class/class-kirki2-kirki.php';
	require_once	plugin_dir_path( __FILE__ ) . '/customizer/kirki-configuration/sections.php';
	require_once	plugin_dir_path( __FILE__ ) . '/customizer/kirki-configuration/fields.php';
	require_once	plugin_dir_path( __FILE__ ) . '/customizer/kirki-configuration/configuration.php'; 
} else {
	require_once	plugin_dir_path( __FILE__ ) . '/customizer/kirki-config-class/kirki-installer.php';
}


/* Radio proxy
=============================================*/




if( !function_exists('qtmplayer_proxy')){
	add_action('init', 'qtmplayer_proxy', 1);
	function qtmplayer_proxy(){
		if(isset($_GET)){
			if(array_key_exists('qtproxycall',$_GET)){


				header('Expires: Sun, 01 Jan 2011 00:00:00 GMT');
				header('Cache-Control: no-store, no-cache, must-revalidate');
				header('Cache-Control: post-check=0, pre-check=0', FALSE);
				header('Pragma: no-cache');
				header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");


				/**
				 * =====================
				 * CACHING SYSTEM
				 * =====================
				 */
				$qt_cache_duration_seconds = 8;
				$IDurl = $_GET['qtproxycall'];
				$transient = 'proradoi_title_'. sanitize_key( $IDurl );
				$oldtitle = get_transient($transient);
				if($oldtitle){
					die( $oldtitle );
					return;
				}
				// END CACHING
				$urlReal = base64_decode( $_GET['qtproxycall'] );
				$title = false;
				if(array_key_exists('debug', $_GET)){
					die( $urlReal );
				}
				if( !array_key_exists('icymetadata', $_GET) ){
					$data = wp_remote_get( $urlReal , array( 'sslverify' => false, 'timeout' => 60 ));
					if(is_wp_error($data)){
						print_r( $data );
						$title = 'Error getting the contents';
					}
					if ( is_array( $data ) ) {
						set_transient( $transient, wp_kses_post($data['body']), $qt_cache_duration_seconds );
						$title = $data['body'];
					}
				} else {
					$title = qtmplayer_getMp3StreamTitle($urlReal);
				}
				if($title){
					$title =  $title ;
					set_transient( $transient,  $title , $qt_cache_duration_seconds );
					die( $title );
				} else {
					die( 'Song title unavailable' );
				}

				die('Unauthorized call');
			} 
		}
	}
}


if( !function_exists('qtmplayer_add_proxy_param')){
	add_action("wp_footer", "qtmplayer_add_proxy_param");
	function qtmplayer_add_proxy_param(){
		?><div id="qtmplayer-radiofeed-proxyurl" class="qt-hidden" data-proxyurl="<?php echo site_url(); ?>"></div> <?php  
	}
}


// Add a body class to hide the player
// Not used for Pro.Radio
if(!function_exists('qtmplayer_manage_body_class')){
	add_filter( 'body_class', 'qtmplayer_manage_body_class' );
	function qtmplayer_manage_body_class($classes){
		if( get_theme_mod( 'qtmplayer_replace_default', '1' ) ){
			$classes[] = 'qtmplayer__hide-audioblock';
		}
		if(isset($_GET)){
			if(isset($_GET['proradio-popup']) || isset($_GET['popup-player'])){
				$classes[] = 'qtmplayer--page-popup';
			}
		}
		if( get_theme_mod( 'qtmplayer_radiochannel_autoselect' ) ){
			$classes[] = 'qtmplayer__radio-autoselect';
		}
		// since PR.3.3.3
		$classes[] = 'qtmplayer-visibility--'.get_theme_mod( 'qtmplayer_visibility', '' );
		return $classes;
	}

}



/**
 * ===========================================================
 * This function can check if the suer has an active subscription.
 * Requires Pro Radio User Manager plugin
 * ===========================================================
 * */
if(!function_exists('qtmplayer_is_premium_active') ){
	function qtmplayer_is_premium_active($subscription_product_id = false){
		if( function_exists('prum_is_premium_active') ){
			return prum_is_premium_active( $subscription_product_id );
		} else {
			return true;
		}
	}
}

if(!function_exists('qtmplayer_post_is_premium') ){
	function qtmplayer_post_is_premium(){
		if( function_exists('prum_post_is_premium') ){
			return prum_post_is_premium(  );
		} else {
			return false;
		}
	}
}


/**
 * =======================================
 * Filter the original resource link
 * =======================================
 */
if(!function_exists('qtmplayer_filter_post_meta')){
	add_filter('get_post_metadata', 'qtmplayer_filter_post_meta', 100, 3);
	function qtmplayer_filter_post_meta($metadata , $object_id, $meta_key){
		if( is_admin() || !function_exists('qtmplayer_post_is_premium')){
			return $metadata;
		}
	   if( $meta_key == '_podcast_resourceurl' || $meta_key == 'enclosure'){
			if( qtmplayer_post_is_premium() ){
				$blocking = 0;
				$required_level = get_option( 'prum-can-listen', 0 );
				$user_level = 1; // Any user
				if(is_user_logged_in()){
					$user_level = 2; // logged user only
				}
				if(qtmplayer_is_premium_active()){
					$user_level = 3; // premium only
				}
				if( $user_level <  $required_level ){
					 return QTMPLAYER_URL . '/assets/audio/blank.mp3';
				}
			}
	    }
	    if( $meta_key == 'buyurl'){
	    	$user_level = 1; // Any user
			if(is_user_logged_in()){
				$user_level = 2; // logged user only
			}
			if(qtmplayer_is_premium_active()){
				$user_level = 3; // premium only
			}
	    	$required_level_download = get_option( 'prum-can-download', 1 );
			if( $user_level <  $required_level_download ){
				if($required_level_download == 2){
					$login_page_id =  get_option('prum-link-page-login' );
					return  get_the_permalink( $login_page_id );
				} else if($required_level_download == 3){
					$premium_p_id = get_option( 'prum-premium-product', false ); 
					return  get_the_permalink( $premium_p_id );
				}
			}
	    }
	    return $metadata;
	}
}

/**
 * =======================================
 * Popup capabilities
 * @since PR.5.0.1 
 * =======================================
 */
if(!function_exists('qtmplater_cta_popup_setting')){
	add_action('wp','qtmplater_cta_popup_setting',1,1);

	
	if(!function_exists('qtmplater_body_class_popup')){
		function qtmplater_body_class_popup($classes){
			$classes[] = 'page-template-page-popup';
			$classes[] = 'qtmplayer-open qtmplayer-open--fixed';
			return $classes;
		}
	}
	function qtmplater_cta_popup_setting($classes){
		if(isset($_GET)){
			if(array_key_exists('qtmplater-popup', $_GET) || isset($_GET['popup-player']) || array_key_exists('proradio-popup', $_GET)  ){
				add_filter('body_class', 'qtmplater_body_class_popup');
				include ( plugin_dir_path( __FILE__ ) . 'templates/popup.php');				
				die();
			}
		}
	}
}












