<?php
/**
 *
 *	Control bar
 *  @package  WordPress
 *  @subpackage qtmplayer
 */

?>
<div id="qtmplayer-controls"  class="qtmplayer__controls" data-hidetimeout="1000">
	<div class="qtmplayer__controllayer">
		<div class="qtmplayer__basic">
			<a id="qtmplayerPlay" data-qtmplayer-playbtn class="qtmplayer__play qtmplayer-btn-secondary">
				<i class="material-icons" aria-label="<?php esc_attr_e('Play','qtmplayer') ?>">play_arrow</i>
				<i id="qtmplayerNotif" data-qtmplayerNotif class="qtmplayer__notification"></i>
			</a>
			<div class="qtmplayer__songdata">
				<p class="qtmplayer__title proradio-marquee"></p>
				<p class="qtmplayer__artist proradio-marquee"></p>
			</div>
			<span data-playeropen class="qtmplayer__openbtn"><i class="material-icons">keyboard_arrow_right</i></span>
		</div>
		<div class="qtmplayer__advanced">
			<div class="qtmplayer__covercontainer">
				<a class="qtmplayer__cover"></a>
			</div>
			<div class="qtmplayer__songdatam">
				<p class="qtmplayer__title"></p>
				<p class="qtmplayer__artist"></p>
			</div>


			<?php  
			include	'stats.php';
			?>

			<div class="qtmplayer__actions">
				<?php  
				if(isset($_GET['proradio-popup'])){
					qtmplayer_volume_control();
				} else {
					?>
					<span class="qtmplayer__spacer"></span>
					<?php
				}
				?>
				<span class="qtmplayer__prev" data-control="prev">
					<i class='material-icons' aria-label="<?php esc_attr_e('Previous','qtmplayer') ?>">skip_previous</i>
				</span>
				<a data-qtmplayer-playbtn class="qtmplayer__playmob">
					<i class="material-icons" aria-hidden="true">play_arrow</i>
					<i id="qtmplayerNotifM" data-qtmplayerNotif class="qtmplayer__notification qtmplayer-content-secondary"></i>
				</a>
				<span class="qtmplayer__next" data-control="next">
					<i class='material-icons' aria-label="<?php esc_attr_e('Next','qtmplayer') ?>">skip_next</i>
				</span>
				<a id="qtmplayerCart" aria-label="<?php esc_attr_e('Open track page','qtmplayer') ?>" href="#" target="_blank" class="qtmplayer__cart <?php if('none' === get_theme_mod( 'qtmplayer_icon_cart', 'inline-block' ) ){ echo 'qtmplayer-hidebtn' ; } ?>">
					<i class='material-icons'></i>
				</a>
			</div>
			<div class="qtmplayer__trackcontainer">
				<div id="qtmplayerTrackControl" data-qtmplayer-trackcontrol class="qtmplayer__track">
					<span id="qtmplayerTime" class="qtmplayer__time" aria-label="<?php esc_attr_e('Time','qtmplayer') ?>">00:00</span>
					<span id="qtmplayerDuration" class="qtmplayer__length" aria-label="<?php esc_attr_e('Duration','qtmplayer') ?>">00:00</span>
					<span id="qtmplayerTrackAdv" class="qtmplayer-track-adv qtmplayer-tbg"></span>
					<span id="qtMplayerBuffer" class="qtmplayer-track-adv qtmplayer-buffer"></span>
					<span id="qtMplayerTadv" data-qtmplayer-trackadv class="qtmplayer-track-adv qtmplayer-content-accent"></span>
					<span id="qtMplayerMiniCue" data-qtmplayer-minicue class="qtmplayer-track-minicue"></span>
					<?php  
					/**
					 * =================================================
					 * Waveform
					 * =================================================
					 */
					if(get_option( 'qtmplayer_waveform' )){ 
						$color = get_theme_mod( 'qtmplayer_color_waveform', '#ffffff' );
						$color_clone = get_theme_mod( 'qtmplayer_color_waveform_play', '#0000ff' );
						?>
						<div id="qtmplayerWaveform" class="qtmplayer__fullwaveform qtmplayer__fullwaveform--large" data-qtmplayer-color="<?php echo esc_attr($color); ?>" data-qtmplayer-color-clone="<?php echo esc_attr($color_clone); ?>">
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<?php if(get_theme_mod( 'qtmplayer_icon_playlist', 'inline-block' ) !== 'none'){ ?>
			<span class="qtmplayer__playlistbtn" data-playlistopen aria-label="<?php esc_attr_e('Play','qtmplayer') ?>">
				<i class='material-icons' aria-label="<?php esc_attr_e('Open playlist','qtmplayer') ?>">playlist_play</i>
			</span>
			<?php } ?>
			<?php  ?>
			<span class="qtmplayer__plclose qtmplayer__plclose__adv" data-playeropen>
				<i class='material-icons' aria-label="<?php esc_attr_e('Close playlist','qtmplayer') ?>">chevron_left</i>
			</span>
			<?php  
			/**
			 * Volume Controller Template
			 * Used also in other functions
			 * 
			 */
			if( !get_theme_mod( 'proradio_vol_header' ) ){
				qtmplayer_volume_control();
			}
			
			?>
			<div class="qtmplayer__bgimg"></div>
		</div>
	</div>
</div>
