<?php
/**
 * 
 * @package qtmplayer
 * @version 3.9.4
 *
 * 
 * 
 */


/**
 * 
 * @since 3.9.4
 * Preload a specific channel first if I'm opening it directly.
 * Enable option in customizer.
 * =============================================
 * 
 * */



$channel_to_exclude = [];
if( get_theme_mod( 'qtmplayer_radiochannel_autoselect' ) ){
	if( is_single()  ){
		$post_ID = get_the_ID();
		if( 'radiochannel' == get_post_type( $post_ID ) ){
			$query_args = [
			    'post_status' => 'publish',
			    'post_type'      => 'radiochannel', 
			    'post__in'       => [$post_ID],
			    'orderby'        => 'post__in',
			    'order'          => 'ASC'
			];
			$wp_query = new WP_Query( $query_args );
			if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
				$post = $wp_query->post;
				setup_postdata( $post );
				$channel_to_exclude[] = $post_ID;
				$id = $post->ID;
				$file = get_post_meta( $id, 'mp3_stream_url', true );
				if( $file ){
					$track_data = qtmplayer_create_track_array($id);
					qtmplayer_create_track( $track_data );
				}
				wp_reset_postdata();
			endwhile; endif;
			wp_reset_postdata();
		}
	}
}




/**
 * 
 * Standard radio channel playlist
 * =============================================
 * 
 * */




$quantity = 0;
$args = array(
	'post_type' => 'radiochannel',
	'post_status' => 'publish',
);
$wp_query = new WP_Query( $args );
$quantity = $quantity + $wp_query->found_posts;

$args = array(
	'post_type' => 'radiochannel',
	'ignore_sticky_posts' => 1,
	'post_status' => 'publish',
	'orderby' => array ( 'menu_order' => 'ASC', 'date' => 'DESC'),
	'suppress_filters' => false,
	'posts_per_page' => -1,
	'paged' => 1,
	'meta_query' => array(
		'relation' => 'OR',
		array(
			'key' => 'qt-excludefromplaylist',
			'compare' => 'NOT EXISTS'
		),
		array(
			'key' => 'qt-excludefromplaylist',
			'value' => false,
			'compare' => '='
		)
	)
);

/**
 * @since 3.9.4
 * If we already preloaded a certain channel first, now it's excluded from reappearing again
 * */
if( $channel_to_exclude ){
	$args['post__not_in'] = $channel_to_exclude; 
}



$wp_query = new WP_Query( $args );
if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
	$post = $wp_query->post;
	setup_postdata( $post );
						
	$id = $post->ID;
	$file = get_post_meta( $id, 'mp3_stream_url', true );
	
	if( $file ){
		$track_data = qtmplayer_create_track_array($id);
		qtmplayer_create_track( $track_data );
	}
	wp_reset_postdata();
endwhile; endif;
wp_reset_postdata();


