<?php 
/**
 * @since   Version PR.3.6.0
 * @package  WordPress
 * @package  ProRadio
 * @subpackage qtmplayer
 */

if(!function_exists('qtmplayer_create_track_array')){
	function qtmplayer_create_track_array($id = null){
		if($id){
			$file = get_post_meta( $id, 'mp3_stream_url', true );
			$minilogo_id = get_post_meta( $id, 'qt_player_icon', true );
			$subtitle = get_post_meta($id, 'qt_radio_subtitle',true);
			$cover = '';
			if( $minilogo_id ){
				$cover = wp_get_attachment_image_src( $minilogo_id, 'medium' );
			}
			if( $cover ){
				$cover = $cover[0];
			}
			
			$track_data = array(
				'qtmpid' => $id,
				'cover'					=> $cover,
				'img_id' 				=> $minilogo_id,
				'title'					=> get_the_title( $id ),
				'artist_name'			=> $subtitle,
				'album'					=> '',
				'buyurl'				=> get_the_permalink( $id ),
				'icon'					=> 'radio',
				'link'					=> get_the_permalink( $id ),
				'price'					=> '',
				'file'					=> trim( $file ),
				'file_mobile' 			=> trim( get_post_meta( $id, 'mp3_stream_url_mobile', true ) ),
				'type'					=> "radio",
				'radiochannel' 			=> '',
				'servertype'			=> get_post_meta( $id, 'proradio_servertype',true ),
				'host' 					=> get_post_meta( $id, 'qtradiofeedHost',true ),
				'port' 					=> get_post_meta( $id, 'qtradiofeedPort',true ),
				'protocol' 				=> get_post_meta( $id, 'qtradiofeedProtocol',true ),
				'icecasturl' 			=> get_post_meta( $id, 'qticecasturl',true ),
				'icecastmountpoint' 	=> get_post_meta( $id, 'qticecastMountpoint',true ),
				'icecastchannel' 		=> get_post_meta( $id, 'qticecastChannel',true ),
				'radiodotco'			=> get_post_meta( $id, 'qtradiodotco',true ),
				'airtime' 				=> get_post_meta( $id, 'qtairtime',true ),
				'radionomy' 			=> get_post_meta( $id, 'qtradionomy',true ),
				'live365' 				=> get_post_meta( $id, 'qtlive365',true ),
				'radioking' 			=> get_post_meta( $id, 'qtradioking',true ),
				'azuracast' 			=> get_post_meta( $id, 'qtazuracast',true ),
				'securesystems' 		=> get_post_meta( $id, 'qtsecuresystems',true ),
				'radiojar' 				=> get_post_meta( $id, 'qtradiojar',true ),
				'radioboss' 			=> get_post_meta( $id, 'qtradioboss',true ),
				'maxcast' 				=> get_post_meta( $id, 'qtmaxcast',true ),
				'textfeed' 				=> get_post_meta( $id, 'qttextfeed',true ),
				'channel' 				=> get_post_meta( $id, 'qtradiofeedChannel',true ),
				'useproxy' 				=> get_post_meta( $id, 'proradio-useproxy', true ),
				'jazler' 				=> get_post_meta( $id, 'qtjazler', true ),
				'streamerr' 			=> get_post_meta( $id, 'qtstreamerr', true ),
				'sonicpanel' 			=> get_post_meta( $id, 'qtsonicpanel', true ),
				'sonicpaneldj' 			=> get_post_meta( $id, 'qtsonicpanel-dj', true ),
				'artwork' 				=> get_post_meta( $id, 'qtartwork', true ),
				'listeners' 			=> get_post_meta( $id, 'qtlisteners', true ),
				'listenerspeak' 		=> get_post_meta( $id, 'qtlistenerspeak', true ),
			);
			return $track_data;
		}
	}
}
		