<?php 
/**
 * @package Pro.Radio Business Tools
 * 
 * Admin Settings:
 * Create forms for the admin
 * 
 * */


if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


if(!function_exists('qtmplayer_form_generator')){
	function qtmplayer_form_generator($title, $controls,  $nonce_action , $nonce_name){
		$user = wp_get_current_user();
		$allowed_roles = array( 'administrator' );
		if( !array_intersect($allowed_roles, $user->roles ) ) {
			echo "This user is not allowed to access this page";
			return;
		}

		/**
		 * =====================================================
		 * 
		 * SAVE Admin settings
		 * 
		 * =====================================================
		 **/

		$msg = false;
		if ( ! empty( $_POST ) ) {
			if(isset($_POST['qtmplayer-submitform'])){
				if(!check_admin_referer( $nonce_action, $nonce_name )){
					echo 'Invalid request';
				} else {
					foreach( $controls as $control ){
						$varname = $control['id'];
						switch ($control['type']){
							case 'checkbox':
								if(isset($_POST[$varname])){
									if($_POST[$varname] == 'on'){
										update_option($varname, 1);
									} 
								} else {
									update_option($varname, 0 );
								}
								break;
							default:
								if(isset($_POST[$varname])){
									update_option($varname, wp_kses($_POST[$varname], array() ));
								}
						}
					}
					flush_rewrite_rules();
				}
			}
		}


		/**
		 * =====================================================
		 * 
		 * OUTPUT
		 * 
		 * =====================================================
		 **/

		?>
		
			
			<h1 class="qtmplayer_settings-modaltitle"><?php echo esc_html( $title ); ?></h1>

			<?php 
			 if( $msg ){
			 	?>
			 	<div id="setting-success-tgmpa" class="notice notice-success " style="margin-left:0;padding: 30px;"><?php 
			 	 echo $msg;
			 	?></div>
			 	<?php 
			 }
			?>
			<div class="qtmplayer__row">
			<form method="post" class="qtmplayer__form" action="<?php echo esc_url($_SERVER["REQUEST_URI"]); ?>">

				<div class="qtmplayer-table-container">
					<table class="form-table" role="presentation">
						<tbody>
							<?php 
							/**
							 * =====================================================
							 * 
							 * Fields loop
							 * 
							 * =====================================================
							 **/
							foreach( $controls as $control ){
								switch ($control['type']){
									/**
									 * ====================================
									 * Section
									 * ====================================
									 **/
									case 'section':
										?>
										<tr class="qtmplayer__row">
											<th colspan="2"><h2><?php echo esc_attr( $control['label']); ?></h2><hr></th>
										</tr>
										<?php 
										break;

									/**
									 * ====================================
									 * Product select
									 * ====================================
									 **/

									case 'productselect':
									
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_attr( $control['label']); ?></th>
											<td>

												<select name="<?php echo esc_attr($control['id']); ?>" id="<?php echo esc_attr($control['id']); ?>">
												<?php
												$args = array(
													'post_type' => "product",
													'posts_per_page' => -1,
													'paged' => 1,
												);
												wp_reset_postdata();
												$wp_query = new WP_Query( $args );
												if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
													$post = $wp_query->post;
													setup_postdata( $post );
													$product = wc_get_product( $post->ID );
													?>
													<option value="<?php echo esc_attr($post->ID); ?>" <?php if( get_option(  $control['id'] ) == $post->ID){ echo 'selected';} ?>><?php echo esc_html($post->post_title); ?></option>
													<?php
												endwhile;
												else:
													?>
													<option value=""><?php echo esc_html($post->post_title); ?></option>
													<?php
												endif;
												wp_reset_postdata();

												 ?>
												</select>
											 <?php echo ( array_key_exists('description', $control) ) ? '<p>'.esc_html( $control['description'] ).'</p>' : ''; ?>
											</td>
										</tr>
										<?php 
										break;

									/**
									 * ====================================
									 * Page select
									 * ====================================
									 **/

									case 'pageselect':
										$posttype = array_key_exists('posttype',  $control ) ?  $control['posttype'] : 'page';
										if ( !post_type_exists( $posttype ) ) {
											echo 'Error: this post type doesn\'t exists';
										}
										$args = array(
											'echo'              => 1,
											'post_type'         => esc_attr($posttype),
											'name'              => esc_attr($control['id'] ),
											'show_option_none'  => 'Select',
										);
										$savedOption = get_option(  $control['id'] );

										if(isset( $savedOption )){
											$args['selected'] = esc_attr( $savedOption );
										}
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_attr( $control['label']); ?></th><td><?php wp_dropdown_pages($args); ?><?php
												echo ( array_key_exists('description', $control) ) ? '<p>'.esc_html( $control['description'] ).'</p>' : ''; 
												?></td>
										</tr>
										<?php 
										break;

									/**
									 * ====================================
									 * Checkbox
									 * ====================================
									 **/

									case 'checkbox':
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_attr( $control['label']); ?></th>
											<td>
												<input id="<?php echo esc_attr( $control['id'] ); ?>" name="<?php echo esc_attr(  $control['id'] ); ?>"  type="checkbox" <?php if (get_option(  $control['id'], $control['default'])){ ?> checked <?php } ?>>
												<?php
												echo ( array_key_exists('description', $control) ) ? esc_html( $control['description'] ) : ''; 
												?>
											</td>
										</tr>
										<?php 
										break;

									/**
									 * ====================================
									 * Radio
									 * ====================================
									 * 
									 **/

									case 'radio':
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_attr( $control['label']); ?></th>
											<td>
												<?php 
												// echo $var.' : STORED OPTION: '.get_option(  $control['id'] );

												foreach($control['options'] as $var => $val){

													?>
													<p>
														<input  name="<?php echo esc_attr(  $control['id'] ); ?>"  type="radio" id="<?php echo esc_attr( $var ); ?>" value="<?php echo esc_attr( $var ); ?>" <?php if ( $var == get_option(  $control['id'], $control['default'] ) ){ ?> checked <?php } ?>>
														<label for="<?php echo esc_attr( $var ); ?>"><?php echo esc_attr( $val ); ?></label>
													</p>
													<?php										
												}
												?>
											</td>
										</tr>
										<?php 
										break;

									/**
									 * 
									 * ====================================
									 * Textarea
									 * ====================================
									 * 
									 **/

									case 'textarea': 
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_html( $control['label'] ); ?></th>
											<td>
												<textarea id="<?php echo esc_attr($control['id']); ?>" name="<?php echo esc_attr($control['id']); ?>"  type="textarea"><?php echo ( get_option( $control['id'], $control['default']) ); ?></textarea>
												<?php
												echo ( array_key_exists('description', $control) ) ? '<p>'.esc_html( $control['description'] ).'</p>' : ''; 
												?>
											</td>
										</tr>
										<?php
										break;


									/**
									 * 
									 * ====================================
									 * Text
									 * ====================================
									 * 
									 **/

									case 'text':
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_html( $control['label'] ); ?></th>
											<td><input id="<?php echo esc_attr($control['id']); ?>" name="<?php echo esc_attr($control['id']); ?>"  type="text" value="<?php echo esc_attr( get_option( $control['id'], $control['default']) ); ?>"><?php   ?>
												<?php
												echo ( array_key_exists('description', $control) ) ? '<p>'.esc_html( $control['description'] ).'</p>' : ''; 
												?>
											</td>
										</tr>
										<?php
										break;

									/**
									 * 
									 * ====================================
									 * Number
									 * ====================================
									 * 
									 **/

									case 'number':
										?>
										<tr class="qtmplayer__row">
											<th><?php echo esc_html( $control['label'] ); ?></th>
											<td><input id="<?php echo esc_attr($control['id']); ?>" name="<?php echo esc_attr($control['id']); ?>"  type="number" value="<?php echo esc_attr( get_option( $control['id'], $control['default']) ); ?>" >
												<?php
												echo ( array_key_exists('description', $control) ) ? '<p>'.esc_html( $control['description'] ).'</p>' : ''; 
												?>
											</td>
										</tr>
										<?php
										break;

									/**
									 * 
									 * ====================================
									 * None or wrong
									 * ====================================
									 * 
									 **/
									default: 
										echo esc_html( $control['label'] );
								}
							}
						?>

						<tr>
						<td colspan="2">
							<?php wp_nonce_field( $nonce_action, $nonce_name, true, true ); ?>
							<input type="submit" name="submit" value="Save"  class="button button-primary" />
						</td>
						</tr>
						</tbody>
					</table>
				</div>
				<input type="hidden" name="qtmplayer-submitform" value="1">
			</form>
		</div>
		<?php 
	}
}