<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorQtPlaces extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-qtplaces'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'QtPlaces Map', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons eicon-google-maps';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}

	public function  qtplaces_elem_types_list(){
		$args = array(
		   'public'   => true,
		   '_builtin' => false
		);
		$post_types = get_post_types( $args, 'names' ); 
		$allowedTypes = array();
		foreach ( $post_types as $post_type ) {
			if(get_option('qtmaps_typeselect_'.$post_type) == '1'){
				$allowedTypes[$post_type] = $post_type;
			}		   
		}
		$allowedTypes['post'] = 'post';
		$allowedTypes['page'] = 'page';
		$allowedTypes['event'] = 'event';
		$allowedTypes['place'] = 'place';
		$allowedTypes = array_unique($allowedTypes);
		return $allowedTypes;
	}

	public function qtplaces_elem_get_terms_array( ) {
		$cats = get_terms(array(
			'hide_empty'=>false,
		));
		$result = array();
		if(is_wp_error( $cats ) || 0 === $cats){
			$result = array();
		}
		$current_taxonomy = '';
		foreach ( $cats as $cat )	{
			if( $cat->taxonomy == 'nav_menu'){
				continue;
			}
			$result[$cat->taxonomy.':'.$cat->slug] = $cat->taxonomy.':'.$cat->slug;
			$result[] = array(
				'value' => $cat->taxonomy.':'.$cat->slug,
				'label' => '['. str_replace('_', ' ', $cat->taxonomy) .'] <strong>'.$cat->name.'</strong>',
			);
		}
		return $result;
	}


	protected function register_controls() {
		$this->start_controls_section(
			'proradio_elementor_section_query_places',
			[
				'label' => esc_html__( 'Query', 'proradio-elementor' ),
			]
		);
			$this->add_control(
				'posttype',
				[
					'label' => esc_html__( 'Post type', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'options' => $this->qtplaces_elem_types_list()
				]
			);


			
			$this->add_control(
				'qtp_tax_filter',
				[
					'label' => esc_html__( 'Category filters', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array()
				]
			);

			$this->add_control(
				'limit',
				[
					'label' => esc_html__( 'Max items', 'proradio-elementor' ),
					'type' => Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 200,
					'step' => 1,
					'default' => 5,
				]
			);




			

		// Fields added by query-fields.php
		$this->end_controls_section();




		/**
		 * ======================================
		 * Section:
		 * grid items parameters
		 * ======================================
		 */
		$this->start_controls_section(
			'proradio_elementor_section_item_design_places',
			[
				'label' => esc_html__( 'Items design', 'proradio-elementor' ),
			]
		);

			
			// Important::::::::::::::::::::::::::::::::::::
			// Fields added by carousel-fields.php
			// :::::::::::::::::::::::::::::::::::::::::::::

			
			$this->add_control(
				'mapheight',
				[
					'label' => esc_html__( 'Map height', 'proradio-elementor' ),
					'type' => Controls_Manager::NUMBER,
					'min' => 100,
					'max' => 800,
					'step' => 20,
					'default' => 400,
				]
			);
			$this->add_control(
				'mapheightmobile',
				[
					'label' => esc_html__( 'Map height mobile', 'proradio-elementor' ),
					'type' => Controls_Manager::NUMBER,
					'min' => 100,
					'max' => 500,
					'step' => 20,
					'default' => 200,
				]
			);
			
			
			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 1,
					'options' =>[
						1 => esc_html__( "1", "proradio-elementor"),
						2 => esc_html__( "2", "proradio-elementor"),
						3 => esc_html__( "3", "proradio-elementor"),
					]
				]
			);

			$this->add_control(
				'open',
				[
					'label' => esc_html__( 'Menu default', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 0,
					'options' =>[
						0 => esc_html__( "Closed", "proradio-elementor"),
						1 => esc_html__( "Open", "proradio-elementor"),
						
					]
				]
			);
			$this->add_control(
				'listimages',
				[
					'label' => esc_html__( 'Display images in the list', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 0,
					'options' =>[
						0 => esc_html__( "No", "proradio-elementor"),
						1 => esc_html__( "Yes", "proradio-elementor"),
						
					]
				]
			);
			$this->add_control(
				'showfilters',
				[
					'label' => esc_html__( 'Show filters', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 0,
					'options' =>[
						0 => esc_html__( "Hide", "proradio-elementor"),
						true => esc_html__( "Show", "proradio-elementor"),
						
					]
				]
			);

			$this->add_control(
				'qtp_filter_taxonomy',
				[
					'label' => esc_html__( 'Filters taxonomy', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => false,
					'options' => get_taxonomies()
				]
			);


			$this->add_control(
				'mapcolor',
				[
					'label' => esc_html__( 'Color scheme', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'normal',
					'options' =>[
						'normal' => esc_html__( "Normal", "proradio-elementor"),
						'dark' => esc_html__( "Dark", "proradio-elementor"),
						'light' => esc_html__( "Light", "proradio-elementor"),
						
					]
				]
			);
			$this->add_control(
				'autozoom',
				[
					'label' => esc_html__( 'Auto zoom', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 0,
					'options' =>[
						0 => esc_html__( "No", "proradio-elementor"),
						'1' => esc_html__( "Yes", "proradio-elementor"),
						
					]
				]
			);
			

			
		$this->end_controls_section();


		/**
		 * Colors
		 */
		$this->start_controls_section(
			'section_button_col',
			[
				'label' => esc_html__( 'Colors', 'elementor-proradio' ),
			]
		);
			$this->add_control(
				'buttoncolor',
				[
					'label' => esc_html__( 'Buttons text color', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-btn' => 'background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'buttonbackground',
				[
					'label' => esc_html__( 'Buttons background color', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .qtPlaces-container .qtPlaces-list .qtPlaces-entry .roundbtn' 			=> 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qtPlaces-container .qtPlaces-marker-img' 			=> 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qtPlaces-container .qtPlaces-marker-img::after'  	=> 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qtPlaces-container .qtPlaces-marker-img::before' 	=> 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'listbackground',
				[
					'label' => esc_html__( 'List background color', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .qtPlaces-container .qtPlaces-list' => 'background-color: {{VALUE}} !important;',
					],
				]
			);
			$this->add_control(
				'markercolor',
				[
					'label' => esc_html__( "Marker icon color", 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .qtPlaces-container .qtPlaces-list .qtPlaces-entry .roundbtn i, {{WRAPPER}} .qtPlaces-container .qtPlaces-map .qtPlaces-mapcontainer .qtPlaces-mapmarker .qtPlaces-marker-img i' => 'color: {{VALUE}} !important;',
					],
				]
			);
			

			

		$this->end_controls_section();


	}
	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		
		if(function_exists('qtplaces_main_shortcode')){
			echo qtplaces_main_shortcode( $atts );
		}
	}
	protected function content_template() {}
}