<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorPostCarousel extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-post-carousel'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Post carousel', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-post-carouse';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}
		/**
	 * @since version PR.2.3.0 loaded from minified scripts.
	 * To unse unminified, edit _plugin.php line 53 $use_minified_script = true;
	 * 
	 * 
	 * */
	// public function __construct($data = [], $args = null) {
 //      parent::__construct($data, $args);
 //      wp_register_script( 'proradio-elementor-post-carousel', plugins_url( '/post-carousel.js', __FILE__ ), [ 'elementor-frontend' ], '1.0.0', true );
 //   	}
 // 	public function get_script_depends() {
	//      return [ 'proradio-elementor-post-carousel' ];
	// }
	protected function register_controls() {

		/**
		 * ======================================
		 * Section:
		 * Carousel parameters
		 * ======================================
		 */
		$this->start_controls_section(
			'proradio_elementor_section_carousel_global',
			[
				'label' => esc_html__( 'Settings', 'proradio-elementor' ),
			]
		);

		// Important::::::::::::::::::::::::::::::::::::
		// Fields added by carousel-fields.php
		// :::::::::::::::::::::::::::::::::::::::::::::
		$this->end_controls_section();

		/**
		 * ======================================
		 * Section:
		 * Carousel parameters
		 * ======================================
		 */
		$this->start_controls_section(
			'proradio_elementor_section_item_design_local',
			[
				'label' => esc_html__( 'Items design', 'proradio-elementor' ),
			]
		);


			$this->add_responsive_control(
				'proradio-minheight',
				[
					'label' => esc_html__( 'Minimum height', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 100,
							'max' => 600,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-post  ' => 'min-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'proradio-proportion',
				[
					'label' => esc_html__( 'Proportion', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 200,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-post .proradio-post__header  ' => 'padding-top: {{SIZE}}%;',
						'{{WRAPPER}} .proradio-post__card  ' => 'padding-top: {{SIZE}}%;',
						
					],
				]
			);
			$this->add_responsive_control(
				'proradio-captionsize',
				[
					'label' => esc_html__( 'Caption size', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 12,
							'max' => 60,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-post__title  ' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);


			$this->add_control(
				'proradio-showmeta',
				[
					'label' => esc_html__( 'Display meta info', 'plugin-domain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'default' => 'block',
					'options' =>[
						"block" => esc_html__( "Yes", 'proradio' ),
						"none" => esc_html__( "No", 'proradio' ),
					],
					'selectors' => [
						'{{WRAPPER}} .proradio-meta  ' => 'display: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'proradio-showcat',
				[
					'label' => esc_html__( 'Display category', 'plugin-domain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'block',
					'options' =>[
						"block" => esc_html__( "Yes", 'proradio' ),
						"none" => esc_html__( "No", 'proradio' ),
					],
					'selectors' => [
						'{{WRAPPER}} .proradio-cats  ' => 'display: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'proradio-showactions',
				[
					'label' => esc_html__( 'Display actions icon', 'plugin-domain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'default' => 'block',
					'options' =>[
						"block" => esc_html__( "Yes", 'proradio' ),
						"none" => esc_html__( "No", 'proradio' ),
					],
					'selectors' => [
						'{{WRAPPER}} .proradio-actions' => 'display: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'proradio-padding-content',
				[
					'label' => __( 'Content padding', 'kentha-elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
			
					'selectors' => [
						'{{WRAPPER}} .proradio-post__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'proradio-padding-header',
				[
					'label' => __( 'Header padding', 'kentha-elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
			
					'selectors' => [
						'{{WRAPPER}} .proradio-post__headercont' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			
		$this->end_controls_section();


		/**
		 * ======================================
		 * Section:
		 * Query parameters
		 * ======================================
		 */
		$this->start_controls_section(
			'proradio_elementor_section_query_global',
			[
				'label' => esc_html__( 'Query', 'proradio-elementor' ),
			]
		);
			$this->add_control(
				'post_type',
				[
					'label' => esc_html__( 'Post type', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'multiple' => false,
					'options' =>[
						"post" => esc_html__( "Post", 'proradio' ),
						"radiochannel" => esc_html__( "Radio channel", 'proradio' ),
						"chart" => esc_html__( "Chart", 'proradio' ),
						"podcast" => esc_html__( "Podcast", 'proradio' ),
						'event' => esc_html__( "Event", 'proradio' ),
						'shows' => esc_html__( "Shows", 'proradio' ),
						'place' =>esc_html__( "Place", 'proradio' ),
						'members' => esc_html__( "Team member", 'proradio' ),
						'product' => esc_html__( "Product", 'proradio' ),
						'qtvideo' => esc_html__( "Video", 'proradio' ),
					]
				]
			);
			$this->add_control(
				'tax_filter',
				[
					'label' => esc_html__( 'Category filters', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array()
				]
			);
			$this->add_control(
				'tax_filter_exc',
				[
					'label' => esc_html__( 'Exclude by category', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'label_block' => true,
					'multiple' => true,
					'options' => proradio_elementor_get_terms_array()
				]
			);
		// Important::::::::::::::::::::::::::::::::::::
		// Fields added by query-fields.php
		// :::::::::::::::::::::::::::::::::::::::::::::
		$this->end_controls_section();

		
	}
	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		if(array_key_exists('tax_filter', $atts)){
			if(is_array($atts['tax_filter'])) {
				$atts['tax_filter'] = implode(',', $atts['tax_filter']);
			}
		}
		if(array_key_exists('tax_filter_exc', $atts)){
			if(is_array($atts['tax_filter_exc'])) {
				$atts['tax_filter_exc'] = implode(',', $atts['tax_filter_exc']);
			}
		}

		if(function_exists('proradio_template_post_carousel')){
			echo proradio_template_post_carousel( $atts );
		}
	}
	protected function content_template() {}
}