<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorGradientCaption extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-gradient-caption'; // need to use same ID in the script js
	}
	public function get_title() {
		return esc_html__( 'Caption gradient', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-caption';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}
		
	protected function register_controls() {
		$this->start_controls_section(
			'section_icons',
			[
				'label' => esc_html__( 'Caption', 'proradio-elementor' ),
			]
		);
			
			
			$this->add_control(
				'proradio-content',
				[
					'label' => esc_html__( 'Caption', 'proradio-elementor' ),
					'default' => 'TITLE {{GRADIENT}}',
					'description' => esc_html__( 'Select the gradient text using {{ }}', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT
				]
			);
			
			
			$this->add_control(
				'htmltag',
				[
					'label' => esc_html__( 'HTML Tag', "elementor-proradio" ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'h3',
					'options' =>[
						'h1'	=>esc_html__('H1', 'proradio' ),
						'h2'	=>esc_html__('H2', 'proradio' ),
						'h3'	=>esc_html__('H3', 'proradio' ),
						'h4'	=>esc_html__('H4', 'proradio' ),
						'h5'	=>esc_html__('H5', 'proradio' ),
						'h6'	=>esc_html__('H6', 'proradio' ),
						
					]
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'proradio-txt-typo',
					'label' => __( 'Typography','vice-elementor'),
					'scheme' => Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}}  .proradio-gradient-caption'
				]
			);

			$this->add_control(
				'text_align',
				[
					'label' => esc_html__( 'Alignment', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'textdomain' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'textdomain' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'textdomain' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => 'center',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .proradio-gradient-caption' => 'text-align: {{VALUE}};',
					],
				]
			);


			$this->add_control(
				'cap-color',
				[
					'label' => esc_html__( 'Text color', 'proradio-elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-gradient-caption' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
			    \Elementor\Group_Control_Background::get_type(),
			    [
			        'name' => 'content_background',
			        'label' => esc_html__('Background', 'proradio-elementor'),
			        'types' => [ 'gradient'],
			         'exclude' => ['image'],
			        'selector' => '{{WRAPPER}} .proradio-gradient-caption span',
			        'fields_options' => [
			            'background' => [
			                'label' => esc_html__('Custom Background', 'pixel-gallery'),
			                'default' => 'classic',
			            ],
			        ],
			    ]
			);

			$this->add_control(
				'pr-mixblend',
				[
					'label' => esc_html__( 'Mix blend mode', "elementor-proradio" ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'h3',
					'options' =>[
						'normal'	=>'Normal',
						'multiply'	=>'multiply' ,
						'screen'	=>'screen' ,
						'overlay'	=>'overlay' ,
						'darken'	=>'darken' ,
						'lighten'	=>'lighten' ,
						'color-dodge'	=>'color-dodge' ,
						'color-burn'	=>'color-burn' ,
						'hard-light'	=>'hard-light' ,
						'soft-light'	=>'soft-light' ,
						'difference'	=>'difference' ,
						'exclusion'	=>'exclusion' ,
						'hue'	=>'hue' ,
						'saturation'	=>'saturation' ,
						'color'	=>'color' ,
						'luminosity'	=>'luminosity' ,
						
					],
					'selectors' => [
						'{{WRAPPER}} ' => 'mix-blend-mode: {{VALUE}};',
					],
				]
			);
			
		$this->end_controls_section();
	}

	/**
	 * Frontend
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		$caption = $atts['proradio-content'];
		$search = array('{{','}}');
		$replace = array('<span>','</span>');
		$caption = str_replace( $search, $replace, $caption );
		?>
		
		<?php echo '<'. esc_attr($atts['htmltag']) .' class="proradio-gradient-caption">'; ?>
		<?php echo wp_kses_post($caption); ?>
		<?php echo '</'. esc_attr($atts['htmltag']) .'>'; ?>
		
		<?php  
	}
	
	protected function content_template() {}
}