( function( $ ) {

	/**====================================================================
	 *
	 * 
	 *  Marquee for longer texts
	 *  
	 * 
	 ====================================================================*/
	var ProradioElementorCustomPlayer = function( $scope, $ ){
		$customplayerElementOb.init($scope, $, $customplayerElementOb);
	}

	var $customplayerElementOb = {
		marqueeInstances: [],
		marqueeText: function(that, customplayers) {

			// console.log('Widget');
			if('function' !== typeof( $.fn.marquee ) ){ // missing marquee library? quit
				console.log('marquee missing');
				return;
			}


			var noMarquees = customplayers.find('.proradio-no-marquee');
			$.each(noMarquees, function(i,c){
				var item = $(c);
				item.marquee('destroy');
			});


			var marquees = customplayers.find('.proradio-customplayer-marquee');
			// Destroy any old instance of the marquee
			if( that.marqueeInstances.length > 0 ){
				for( var mi = 0; mi < that.marqueeInstances.length; mi++ ){
					if( 'undefined' !== typeof( that.marqueeInstances[mi] )){
						that.marqueeInstances[mi].marquee('destroy');
					}
				}
				that.marqueeInstances = []; // reset
			}
			$.each(marquees, function(i,c){
				var item = $(c);
				if(item.find('.marquee').length === 0){
					item.html('<span class="marquee">'+item.html()+'</span>');
				}
				if(  item.outerWidth() >  item.find('.marquee').outerWidth() ){ // the title is short? quit!
					return;
				}
				that.marqueeInstances[i] = item.marquee({
					duration: 12000,
					gap: item.outerWidth(),
					delayBeforeStart: 1000,
					direction: 'left',
					duplicated: false,
					pauseOnCycle: 5000,
					startVisible: true
				});
			});
		},
		init : function( $scope, $, that ) {
			
			try {
				var qtartworkInterval2 = false;
				var qtartworkCache2 = false;
				var qtcurrentImage2 = false;
				var titlecache = false;
				var newtitle = false;
				var qtart, qtimg;
				var customplayers = $('.proradio-customplayer');
				if(customplayers.length > 0){
					// artwork
					var artworks = customplayers.find('.proradio-customplayer__art');
					if(qtartworkInterval2){
						clearInterval(qtartworkInterval2); 
					}	
					qtart = $('.proradio-customplayer__art');
					qtimg = $('.proradio-customplayer__art img');
					qtartworkInterval2 = setInterval(function(){
						newtitle =  $( '#qtmplayer .qtmplayer__title').html();
						if(titlecache !== newtitle){
							customplayers.find('.proradio-customplayer__title').html( newtitle );
							customplayers.find('.proradio-customplayer__artist').html( $( '#qtmplayer .qtmplayer__artist').html()  );
							titlecache = newtitle;
							$customplayerElementOb.marqueeText(that, customplayers);
						}
						if(artworks.length > 0){
							qtcurrentImage2 = $('.qtmplayer__cover img').attr('src');
							if(qtcurrentImage2 !== qtartworkCache2){ 
								qtartworkCache2 = qtcurrentImage2; 
							}
							if( qtartworkCache2 ){
								qtimg.attr('src', qtartworkCache2);
								qtart.attr('href', qtartworkCache2);
							}
							if($('.qtmplayer__cover img').attr("style") === 'display: none;'){
								qtart.addClass('proradio-hidden');
							} else {
								qtart.removeClass('proradio-hidden');	
							}
						} else {
							qtart.addClass('proradio-hidden');
						}
					},1000); // arbitrary delay for refresh to avoid js overload. 				
				}
			} catch(e) {
				console.log(e);
			}
		}
	};
	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/proradio-elementor-customplayer.default', ProradioElementorCustomPlayer );
	} );
} )( jQuery );