<?php
/**
 * @source  https://developers.elementor.com/elementor-controls/
 * @author  Pro.Radio
 * @package  Elementor Proradio
 * @version  1.0.0
 */


namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ProradioElementorAppIcons extends Widget_Base {
	public function get_name() {
		return 'proradio-elementor-qt-appicons'; // need to use same ID in the script js
	}
	public function get_title() {
		return __( 'Streaming App Icons', 'proradio-elementor' );
	}
	public function get_icon() {
		return 'proradio-elementor-icons icon-prel-streaming-app-icons';
	}
	public function get_categories() {
		return [ 'aaa-proradio' ]; // needs to be registered in _plugin.php
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_icons',
			[
				'label' => __( 'Icons', 'proradio-elementor' ),
			]
		);
			$this->add_control(
				'app_blackberry',
				[
					'label' => esc_html__( 'Blackberry', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_itunes',
				[
					'label' => esc_html__( 'iTunes', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_huawei',
				[
					'label' => esc_html__( 'Huawei', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_winphone',
				[
					'label' => esc_html__( 'Windows', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_winamp',
				[
					'label' => esc_html__( 'WinAmp', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_tunein',
				[
					'label' => esc_html__( 'TuneIn', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_mediaplayer',
				[
					'label' => esc_html__( 'Media Player', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_android',
				[
					'label' => esc_html__( 'Android', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'app_iphone',
				[
					'label' => esc_html__( 'iPhone', 'proradio-elementor' ),
					'type' => Controls_Manager::TEXT,
				]
			);
		$this->end_controls_section();


		$this->start_controls_section(
			'proradio_section_button_design',
			[
				'label' => esc_html__( 'Design', 'elementor-proradio' ),
			]
		);

			$this->add_responsive_control(
				'btn-size',
				[
					'label' => esc_html__( 'Size', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 120,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-appicon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon-size',
				[
					'label' => esc_html__( 'Icon size', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 120,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-appicon span' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};background-size: {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}};',
					],
				]
			);
			

			$this->add_responsive_control(
				'pr_padding',
				[
					'label' => __( 'Padding', 'kentha-elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'default' =>[
						'isLinked' => false,
						],
					'selectors' => [
						'{{WRAPPER}} .proradio-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);


			$this->add_responsive_control(
				'btn-radius',
				[
					'label' => esc_html__( 'Border-radius', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 300,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();

		/**
		 * Colors
		 */
		$this->start_controls_section(
			'section_button_col',
			[
				'label' => esc_html__( 'Colors', 'elementor-proradio' ),
			]
		);
			$this->add_control(
				'proradio-btn-bg',
				[
					'label' => esc_html__( 'Background', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-btn' => 'background: {{VALUE}} !important;',
					],
				]
			);
	

			

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'proradio-btn-border',
					'label' => __( 'Border', 'plugin-domain' ),
					'selector' => '{{WRAPPER}} .proradio-btn',
				]
			);

			

		$this->end_controls_section();

		/**
		 * Colors hover
		 */
		$this->start_controls_section(
			'section_button_col_h',
			[
				'label' => esc_html__( 'Colors hover', 'elementor-proradio' ),
			]
		);
			$this->add_control(
				'proradio-btn-bgh',
				[
					'label' => esc_html__( 'Background hover', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-btn:hover, {{WRAPPER}} .proradio-btn:hover::after' => 'background: {{VALUE}} !important;',
					]
				]
			);
			$this->add_control(
				'proradio-btn-bch',
				[
					'label' => esc_html__( 'Border hover', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .proradio-btn:hover' => 'border-color: {{VALUE}} !important;',
					]
				]
			);
			

		$this->end_controls_section();
	}

	/**
	 * Frontend
	 */
	protected function render() {
		if(function_exists('proradio_appicons')){
			echo proradio_appicons( $this->get_settings_for_display() );
		}
	}

	
	protected function content_template() {}
}