<?php
/**
 * @package WordPress
 * @subpackage proradio-dedications
 * @version 1.0.0
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if(!function_exists('prdedications_user_notice')){
	add_action( 'publish_prdedicationslist', 'prdedications_user_notice', 10, 2 );
	function prdedications_user_notice( $post_id, $post){
		if(get_option( 'prdedications-request-email' ) && get_option( 'prdedications-user-notify' )){
			$email = get_post_meta( $post_id, 'prdedication_email', true );
		    if(!$email){
		    	return;
		    }

			$name = esc_html__('listener', 'proradio-dedications');
			if(get_option( 'prdedications-request-name' )){
		    	$name = get_post_meta( $post_id, 'prdedication_name', true ); 
		    }
		   
		    $to[] = sprintf( '%s <%s>', $name, $email );

		    // Subject
		    $custom_subject = get_option( 'prdedications-subject' );
		    $subject = ($custom_subject)? $custom_subject :   __('Good news, your dedication has been published.', 'proradio-dedications');
		   
		   	 // message
		    $custom_message = get_option( 'prdedications-message' );
		    $default_message = esc_html( sprintf ( __('Congratulations, %s! Your dedication has been published. You can now see it live and share our link.', 'proradio-dedications') . "\n\n", $name )).get_site_url();
		    $message = ( $custom_message ) ? wp_kses_post( $custom_message ) : $default_message;
		   
		  
		    $headers[] = '';

		    wp_mail( $to, $subject, $message, $headers );
		}
	}
}