<?php
/**
 * @package WordPress
 * @subpackage proradio-dedications
 * @version 1.3.0
 */

if(!function_exists('proradio_dedications_list')){
	function proradio_dedications_list($atts){
		/*
		 *  Defaults
		 *  All parameters can be bypassed by same attribute in the shortcode
		 */
		extract( shortcode_atts( array(
			'items_per_page'=> 3,
			'duration' => 60,
			'autoscroll' => false
		), $atts ) );
		$duration = intval($duration) * 5000;
		ob_start();
		remove_filter ('the_content', 'wpautop');
	   ?>
	   <div class="proradio-dedications-list">
	   		<div  <?php if($autoscroll){ ?> class="proradio-dedications-marquee"  data-duplicated='true' data-direction='up' data-duration='<?php echo esc_attr( $duration ); ?>' style="overflow: hidden;" <?php } ?> >
				<ul >
                
                    <?php 
                    $args = array(
                        'post_type'             => 'prdedicationslist',
                        'post_status'           => 'publish',
                        'ignore_sticky_posts'   => 1,
                        'posts_per_page'        => $items_per_page,
                        'paged'                 => 1,
                        'orderby'               => array ('menu_order' => 'ASC', 'date' => 'DESC')
                    );
                    $wp_query = new WP_Query( $args );
                    if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post();
                        $post = $wp_query->post;
                         setup_postdata( $post );
                         $name =  get_post_meta( get_the_ID(), 'prdedication_name', true );
                         $song =  get_post_meta( get_the_ID(), 'prdedication_song', true );
                        $art =  get_post_meta( get_the_ID(), 'prdedication_art', true );
                        $artlink = str_replace('100x100bb.jpg', '1000x1000bb.jpg', $art);
                         if(!$name){
                            $name = esc_html__('Dedication', 'proradio-dedication');
                         }
                         $content = get_the_content();
                        ?>
                        <li>
                            <span class="proradio-dedication-name"><?php echo esc_html( $name ); ?></span>
                            <?php  
                            if($art){
                                ?><a href="<?php echo esc_url( $artlink ); ?>" class="proradio-dedication-thumb"><img src="<?php echo esc_url($art); ?>" width="60px" height="60px"></a><?php
                            }
                            if($song){
                                if($art){ ?><a href="<?php echo esc_url($artlink ); ?>"><?php  }
                                ?><span class="proradio-dedication-song"><?php
                                echo esc_html( $song );
                                ?></span> <?php  
                                if($art){ ?></a><?php  }
                            }

                            ?>
                            <span><?php echo wp_kses_post( wp_strip_all_tags( $content) ); ?></span>
                        </li>
                        <?php  
                    endwhile; else:
                        esc_html_e("Currently there are no new dedications","proradio-dedications"); 
                    endif;
                    wp_reset_postdata();
                    ?>
                </ul>

			</div>
		</div>
		<?php  

		add_filter ('the_content', 'wpautop');
		echo ob_get_clean();

	}   
}