<?php
/**
* @package t2gicons
* @author Themes2Go
* @textdomain t2gicons
*/
?>
<h4><?php echo esc_attr__("Shortcode settings") ?></h4>
<div class="t2gicons-card">
	<h6><?php echo esc_attr__("Shortcode structure", "t2gicons"); ?></h6>
	<p><strong>[t2gicons icon="" size="" fontsize="" bgcolor="" color="" shape="" align="" link="" target="" type=""  ]</strong></p>
	<table class="table">
		<tr>
			<th><?php echo esc_attr__("Parameter", "t2gicons"); ?></th>
			<th><?php echo esc_attr__("Usage", "t2gicons"); ?></th>
			<th><?php echo esc_attr__("Possible values", "t2gicons"); ?></th>
		</tr>
		<tr>
			<td>icon</td>
			<td><?php echo esc_attr__("Css icon class","t2gicons"); ?></td>
			<td><?php echo esc_attr__("Check class names in hover or use the Visual Composer or TinyMCE icon generator.","t2gicons"); ?></td>
		</tr>
		<tr>
			<td>size</td>
			<td><?php echo esc_attr__("Background shape size (fixed values)","t2gicons"); ?></td>
			<td>[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200]</td>
		</tr>
		<tr>
			<td>fontsize</td>
			<td><?php echo esc_attr__("Symbol size (fixed values)","t2gicons"); ?></td>
			<td>[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200]</td>
		</tr>
		<tr>
			<td>bgcolor</td>
			<td><?php echo esc_attr__("Background color","t2gicons"); ?></td>
			<td>[red, pink, purple, deep-purple, indigo, blue, light-blue, cyan, teal, green, light-green, lime, yellow, amber, orange, deep-orange, brown, grey, blue-grey, black, white, transparent]</td>
		</tr>
		<tr>
			<td>color</td>
			<td><?php echo esc_attr__("Icon color","t2gicons"); ?></td>
			<td>[red, pink, purple, deep-purple, indigo, blue, light-blue, cyan, teal, green, light-green, lime, yellow, amber, orange, deep-orange, brown, grey, blue-grey, black, white, transparent]</td>
		</tr>
		<tr>
			<td>shape</td>
			<td><?php echo esc_attr__("Background shape","t2gicons"); ?></td>
			<td>[none, circle, square, rsquare, rhombus, circle-border, square-border, rsquare-border, rhombus-border]</td>
		</tr>
		<tr>
			<td>align</td>
			<td><?php echo esc_attr__("Icon alignment","t2gicons"); ?></td>
			<td>[none, left, center, right]</td>
		</tr>
		<tr>
			<td>link</td>
			<td><?php echo esc_attr__("Link URL","t2gicons"); ?></td>
			<td>http://...</td>
		</tr>
		<tr>
			<td>target</td>
			<td><?php echo esc_attr__("Target for your link","t2gicons"); ?></td>
			<td>[none, _top, _blank]</td>
		</tr>
		<tr>
			<td>type</td>
			<td><?php echo esc_attr__("Icon set name","t2gicons"); ?></td>
			<td><?php echo esc_attr__("Auto-generated by Visual composer, not needed for manual shortcode use", "t2gicons"); ?></td>
		</tr>
	</table>
</div>