<?php

$features = [
	[
		'title' => __( 'Frontend Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Admin Dashboard Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Auto Match OS-Theme', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Time-based Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Default Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'WordPress Login & Register Page Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Multiple Toggle Button Styles', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Floating Dark Mode Toggle Button', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Darken Background Images', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Image Brightness, Grayscale and Insert Control', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Dynamic Dark Mode Colors', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Classic Editor Dark Mode Compatibility', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Gutenberg Editor Dark Mode Compatibility', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Toggle Button Shortcode', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Save User Choice', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Keyboard Shortcut', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Gutenberg Toggle Button Block (Coming Soon)', 'dracula-dark-mode' ),
	],
	[
		'title' => __( 'Elementor Toggle Button Block (Coming Soon)', 'dracula-dark-mode' ),
	],

	//PRO Features

	[
		'title'   => __( 'Reading Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Display Toggle Button in Menu', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Dark Mode Based Image Support', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Dark Mode Based Video Support', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Dark Mode Color Brightness, Contrast, Sepia, and Grayscale Adjustments', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Toggle Button Size Customization', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Toggle Button Position Customization', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Customize Toggle Button Text & Colors', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Dark Mode Colors Customization and Multiple Color Presets', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Excludes Specific Sections & Elements in a Page', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Exclude Pages/ Posts/ Custom Post Types', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Custom CSS For Dark Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( '8+ Dark Mode Toggle Button Styles', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Enable/ Disable Dark Mode by URL Parameter', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Draggable Floating Switch', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Dark Mode Based Typography (Font Family + Font Size + Text Stroke)', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => __( 'Performance Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],

	[
		'title'   => __( 'Realtime Dark Mode Customization', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => __( 'Page Wise Dark Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => __( 'Custom Dark Mode Toggle Button Builder', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => __( '14+ Dark Mode Toggle Button Styles', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => __( 'Dashboard Dark Mode for Specific User Roles', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => __( 'Usage Analytics & Email Report (Coming Soon)', 'dracula-dark-mode' ),
		'isPro' => true,
	],

	[
		'title'   => __( 'Dark Mode Page Transition Animation (coming soon)', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => __( 'Toggle Button Attention Effect Animation (coming soon)', 'dracula-dark-mode' ),
		'isPro' => true,
	],
];

?>

<div id="get-pro" class="getting-started-content content-get-pro">
    <div class="content-heading">
        <h2><?php esc_html_e('Get Access to Exclusive Features with The Dracula Dark Mode Premium', 'dracula-dark-mode'); ?></h2>
        <p><?php esc_html_e('The amazing premium features will take your website to the next level.', 'dracula-dark-mode'); ?></p>
    </div>

    <div class="get-pro-cta">
        <div class="cta-content">
            <h2><?php esc_html_e('Don\'t waste time, unlock premium features now!', 'dracula-dark-mode'); ?></h2>
            <p>
                <?php esc_html_e('Upgrade to Dracula Dark Mode premium now and experience a whole new level of darkness. Get exclusive
                features and support the development of this theme. Don\'t miss out on the ultimate dark mode experience. Buy now!', 'dracula-dark-mode'); ?>
            </p>
        </div>

        <div class="cta-btn">
            <a href="<?php echo esc_url(ddm_fs()->get_upgrade_url()); ?>" class="dracula-btn btn-primary"><?php esc_html_e('Upgrade Now', 'dracula-dark-mode'); ?></a>
        </div>

    </div>

    <div class="content-heading compare-pans">
        <h2><?php esc_html_e('Compare Plans', 'dracula-dark-mode'); ?></h2>
        <h3>
            <span class="plan-name plan-free"><?php esc_html_e('Free', 'dracula-dark-mode'); ?></span>
            <span class="vs"><?php esc_html_e('vs', 'dracula-dark-mode'); ?></span>
            <span class="plan-name plan-pro"><?php esc_html_e('Pro', 'dracula-dark-mode'); ?></span>
    </div>

    <div class="features-list">
        <div class="list-header">
            <div class="feature-title"><?php esc_html_e('Features', 'dracula-dark-mode'); ?></div>
            <div class="feature-free"><?php esc_html_e('Free', 'dracula-dark-mode'); ?></div>
            <div class="feature-pro"><?php esc_html_e('Pro', 'dracula-dark-mode'); ?></div>
        </div>

		<?php foreach ( $features as $feature ) : ?>
            <div class="feature">
                <div class="feature-title"><?php echo esc_html( $feature['title'] ); ?></div>
                <div class="feature-free">
					<?php if ( ! empty( $feature['isPro'] )) : ?>
                        <i class="dashicons dashicons-no-alt"></i>
					<?php else : ?>
                        <i class="dashicons dashicons-saved"></i>
					<?php endif; ?>
                </div>

                <div class="feature-pro">
                    <i class="dashicons dashicons-saved"></i>
                </div>
            </div>
		<?php endforeach; ?>

    </div>

    <div class="get-pro-cta">
        <div class="cta-content">
            <h2><?php esc_html_e('Why wait? Dive into the PRO features today!', 'dracula-dark-mode'); ?></h2>
            <p>
				<?php esc_html_e('Upgrade to Dracula Dark Mode premium now and experience a whole new level of darkness. Get exclusive
                features and support the development of this awesome plugin. Don\'t miss out on the ultimate dark mode experience. Buy now!', 'dracula-dark-mode'); ?>
            </p>
        </div>

        <div class="cta-btn">
            <a href="<?php echo esc_url(ddm_fs()->get_upgrade_url()); ?>" class="dracula-btn btn-primary"><?php esc_html_e('Get PRO', 'dracula-dark-mode'); ?></a>
        </div>

    </div>

    <div class="demo-cta">
        <div class="cta-content">
            <h2><?php esc_html_e('Try all the PRO features, before purchase', 'dracula-dark-mode'); ?></h2>
            <p><?php esc_html_e('You can try our instant ready-made demo. The demo allows you to experiment with all the functionality of
                the plugins on both Front-End and Back-End. Feel free to explore the possibilities and limits of our
                plugins to see if it fits your requirements!', 'dracula-dark-mode'); ?></p>
        </div>

        <div class="cta-btn">
            <a href="https://demo.softlabbd.com/?product=dracula-dark-mode" class="dracula-btn btn-primary" target="_blank"><?php esc_html_e('Try Live Demo', 'dracula-dark-mode'); ?></a>
        </div>

    </div>

</div>